package com.google.gerrit.server.mail.send;

import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountSshKey;
import java.util.List;
import javax.annotation.processing.Generated;
import javax.inject.Inject;
import javax.inject.Provider;

@Generated(
    value = "com.google.auto.factory.processor.AutoFactoryProcessor",
    comments = "https://github.com/google/auto/tree/master/factory"
)
public final class AddKeyEmailDecoratorFactory {
  private final Provider<MessageIdGenerator> messageIdGeneratorProvider;

  @Inject
  public AddKeyEmailDecoratorFactory(Provider<MessageIdGenerator> messageIdGeneratorProvider) {
    this.messageIdGeneratorProvider = checkNotNull(messageIdGeneratorProvider, 1);
  }

  public AddKeyEmailDecorator create(IdentifiedUser user, AccountSshKey sshKey) {
    return new AddKeyEmailDecorator(checkNotNull(messageIdGeneratorProvider.get(), 1), checkNotNull(user, 2), checkNotNull(sshKey, 3));
  }

  public AddKeyEmailDecorator create(IdentifiedUser user, List<String> gpgKeys) {
    return new AddKeyEmailDecorator(checkNotNull(messageIdGeneratorProvider.get(), 1), checkNotNull(user, 2), checkNotNull(gpgKeys, 3));
  }

  private static <T> T checkNotNull(T reference, int argumentIndex) {
    if (reference == null) {
      throw new NullPointerException("@AutoFactory method argument is null but is not marked @Nullable. Argument index: " + argumentIndex);
    }
    return reference;
  }
}
