package com.google.gerrit.server.notedb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.AttentionSetUpdate;
import com.google.gerrit.entities.Change;
import com.google.gerrit.entities.ChangeMessage;
import com.google.gerrit.entities.HumanComment;
import com.google.gerrit.entities.PatchSet;
import com.google.gerrit.entities.PatchSetApproval;
import com.google.gerrit.entities.SubmitRecord;
import com.google.gerrit.entities.SubmitRequirementResult;
import com.google.gerrit.server.ReviewerByEmailSet;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.ReviewerStatusUpdate;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ChangeNotesState extends ChangeNotesState {

  private final ObjectId metaId;

  private final Change.Id changeId;

  private final ChangeNotesState.ChangeColumns columns;

  private final ImmutableSet<String> hashtags;

  private final ImmutableList<Map.Entry<String, String>> customKeyedValues;

  private final String serverId;

  private final ImmutableList<Map.Entry<PatchSet.Id, PatchSet>> patchSets;

  private final ImmutableList<Map.Entry<PatchSet.Id, PatchSetApproval>> approvals;

  private final ReviewerSet reviewers;

  private final ReviewerByEmailSet reviewersByEmail;

  private final ReviewerSet pendingReviewers;

  private final ReviewerByEmailSet pendingReviewersByEmail;

  private final ImmutableList<Account.Id> allPastReviewers;

  private final ImmutableList<ReviewerStatusUpdate> reviewerUpdates;

  private final ImmutableSet<AttentionSetUpdate> attentionSet;

  private final ImmutableList<AttentionSetUpdate> allAttentionSetUpdates;

  private final ImmutableList<SubmitRecord> submitRecords;

  private final ImmutableList<ChangeMessage> changeMessages;

  private final ImmutableListMultimap<ObjectId, HumanComment> publishedComments;

  private final ImmutableList<SubmitRequirementResult> submitRequirementsResult;

  private final int updateCount;

  private final Instant mergedOn;

  private AutoValue_ChangeNotesState(
      @Nullable ObjectId metaId,
      Change.Id changeId,
      @Nullable ChangeNotesState.ChangeColumns columns,
      ImmutableSet<String> hashtags,
      ImmutableList<Map.Entry<String, String>> customKeyedValues,
      @Nullable String serverId,
      ImmutableList<Map.Entry<PatchSet.Id, PatchSet>> patchSets,
      ImmutableList<Map.Entry<PatchSet.Id, PatchSetApproval>> approvals,
      ReviewerSet reviewers,
      ReviewerByEmailSet reviewersByEmail,
      ReviewerSet pendingReviewers,
      ReviewerByEmailSet pendingReviewersByEmail,
      ImmutableList<Account.Id> allPastReviewers,
      ImmutableList<ReviewerStatusUpdate> reviewerUpdates,
      ImmutableSet<AttentionSetUpdate> attentionSet,
      ImmutableList<AttentionSetUpdate> allAttentionSetUpdates,
      ImmutableList<SubmitRecord> submitRecords,
      ImmutableList<ChangeMessage> changeMessages,
      ImmutableListMultimap<ObjectId, HumanComment> publishedComments,
      ImmutableList<SubmitRequirementResult> submitRequirementsResult,
      int updateCount,
      @Nullable Instant mergedOn) {
    this.metaId = metaId;
    this.changeId = changeId;
    this.columns = columns;
    this.hashtags = hashtags;
    this.customKeyedValues = customKeyedValues;
    this.serverId = serverId;
    this.patchSets = patchSets;
    this.approvals = approvals;
    this.reviewers = reviewers;
    this.reviewersByEmail = reviewersByEmail;
    this.pendingReviewers = pendingReviewers;
    this.pendingReviewersByEmail = pendingReviewersByEmail;
    this.allPastReviewers = allPastReviewers;
    this.reviewerUpdates = reviewerUpdates;
    this.attentionSet = attentionSet;
    this.allAttentionSetUpdates = allAttentionSetUpdates;
    this.submitRecords = submitRecords;
    this.changeMessages = changeMessages;
    this.publishedComments = publishedComments;
    this.submitRequirementsResult = submitRequirementsResult;
    this.updateCount = updateCount;
    this.mergedOn = mergedOn;
  }

  @Nullable
  @Override
  ObjectId metaId() {
    return metaId;
  }

  @Override
  Change.Id changeId() {
    return changeId;
  }

  @Nullable
  @Override
  ChangeNotesState.ChangeColumns columns() {
    return columns;
  }

  @Override
  ImmutableSet<String> hashtags() {
    return hashtags;
  }

  @Override
  ImmutableList<Map.Entry<String, String>> customKeyedValues() {
    return customKeyedValues;
  }

  @Nullable
  @Override
  String serverId() {
    return serverId;
  }

  @Override
  ImmutableList<Map.Entry<PatchSet.Id, PatchSet>> patchSets() {
    return patchSets;
  }

  @Override
  ImmutableList<Map.Entry<PatchSet.Id, PatchSetApproval>> approvals() {
    return approvals;
  }

  @Override
  ReviewerSet reviewers() {
    return reviewers;
  }

  @Override
  ReviewerByEmailSet reviewersByEmail() {
    return reviewersByEmail;
  }

  @Override
  ReviewerSet pendingReviewers() {
    return pendingReviewers;
  }

  @Override
  ReviewerByEmailSet pendingReviewersByEmail() {
    return pendingReviewersByEmail;
  }

  @Override
  ImmutableList<Account.Id> allPastReviewers() {
    return allPastReviewers;
  }

  @Override
  ImmutableList<ReviewerStatusUpdate> reviewerUpdates() {
    return reviewerUpdates;
  }

  @Override
  ImmutableSet<AttentionSetUpdate> attentionSet() {
    return attentionSet;
  }

  @Override
  ImmutableList<AttentionSetUpdate> allAttentionSetUpdates() {
    return allAttentionSetUpdates;
  }

  @Override
  ImmutableList<SubmitRecord> submitRecords() {
    return submitRecords;
  }

  @Override
  ImmutableList<ChangeMessage> changeMessages() {
    return changeMessages;
  }

  @Override
  ImmutableListMultimap<ObjectId, HumanComment> publishedComments() {
    return publishedComments;
  }

  @Override
  ImmutableList<SubmitRequirementResult> submitRequirementsResult() {
    return submitRequirementsResult;
  }

  @Override
  int updateCount() {
    return updateCount;
  }

  @Nullable
  @Override
  Instant mergedOn() {
    return mergedOn;
  }

  @Override
  public String toString() {
    return "ChangeNotesState{"
        + "metaId=" + metaId + ", "
        + "changeId=" + changeId + ", "
        + "columns=" + columns + ", "
        + "hashtags=" + hashtags + ", "
        + "customKeyedValues=" + customKeyedValues + ", "
        + "serverId=" + serverId + ", "
        + "patchSets=" + patchSets + ", "
        + "approvals=" + approvals + ", "
        + "reviewers=" + reviewers + ", "
        + "reviewersByEmail=" + reviewersByEmail + ", "
        + "pendingReviewers=" + pendingReviewers + ", "
        + "pendingReviewersByEmail=" + pendingReviewersByEmail + ", "
        + "allPastReviewers=" + allPastReviewers + ", "
        + "reviewerUpdates=" + reviewerUpdates + ", "
        + "attentionSet=" + attentionSet + ", "
        + "allAttentionSetUpdates=" + allAttentionSetUpdates + ", "
        + "submitRecords=" + submitRecords + ", "
        + "changeMessages=" + changeMessages + ", "
        + "publishedComments=" + publishedComments + ", "
        + "submitRequirementsResult=" + submitRequirementsResult + ", "
        + "updateCount=" + updateCount + ", "
        + "mergedOn=" + mergedOn
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ChangeNotesState) {
      ChangeNotesState that = (ChangeNotesState) o;
      return (this.metaId == null ? that.metaId() == null : this.metaId.equals(that.metaId()))
          && this.changeId.equals(that.changeId())
          && (this.columns == null ? that.columns() == null : this.columns.equals(that.columns()))
          && this.hashtags.equals(that.hashtags())
          && this.customKeyedValues.equals(that.customKeyedValues())
          && (this.serverId == null ? that.serverId() == null : this.serverId.equals(that.serverId()))
          && this.patchSets.equals(that.patchSets())
          && this.approvals.equals(that.approvals())
          && this.reviewers.equals(that.reviewers())
          && this.reviewersByEmail.equals(that.reviewersByEmail())
          && this.pendingReviewers.equals(that.pendingReviewers())
          && this.pendingReviewersByEmail.equals(that.pendingReviewersByEmail())
          && this.allPastReviewers.equals(that.allPastReviewers())
          && this.reviewerUpdates.equals(that.reviewerUpdates())
          && this.attentionSet.equals(that.attentionSet())
          && this.allAttentionSetUpdates.equals(that.allAttentionSetUpdates())
          && this.submitRecords.equals(that.submitRecords())
          && this.changeMessages.equals(that.changeMessages())
          && this.publishedComments.equals(that.publishedComments())
          && this.submitRequirementsResult.equals(that.submitRequirementsResult())
          && this.updateCount == that.updateCount()
          && (this.mergedOn == null ? that.mergedOn() == null : this.mergedOn.equals(that.mergedOn()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (metaId == null) ? 0 : metaId.hashCode();
    h$ *= 1000003;
    h$ ^= changeId.hashCode();
    h$ *= 1000003;
    h$ ^= (columns == null) ? 0 : columns.hashCode();
    h$ *= 1000003;
    h$ ^= hashtags.hashCode();
    h$ *= 1000003;
    h$ ^= customKeyedValues.hashCode();
    h$ *= 1000003;
    h$ ^= (serverId == null) ? 0 : serverId.hashCode();
    h$ *= 1000003;
    h$ ^= patchSets.hashCode();
    h$ *= 1000003;
    h$ ^= approvals.hashCode();
    h$ *= 1000003;
    h$ ^= reviewers.hashCode();
    h$ *= 1000003;
    h$ ^= reviewersByEmail.hashCode();
    h$ *= 1000003;
    h$ ^= pendingReviewers.hashCode();
    h$ *= 1000003;
    h$ ^= pendingReviewersByEmail.hashCode();
    h$ *= 1000003;
    h$ ^= allPastReviewers.hashCode();
    h$ *= 1000003;
    h$ ^= reviewerUpdates.hashCode();
    h$ *= 1000003;
    h$ ^= attentionSet.hashCode();
    h$ *= 1000003;
    h$ ^= allAttentionSetUpdates.hashCode();
    h$ *= 1000003;
    h$ ^= submitRecords.hashCode();
    h$ *= 1000003;
    h$ ^= changeMessages.hashCode();
    h$ *= 1000003;
    h$ ^= publishedComments.hashCode();
    h$ *= 1000003;
    h$ ^= submitRequirementsResult.hashCode();
    h$ *= 1000003;
    h$ ^= updateCount;
    h$ *= 1000003;
    h$ ^= (mergedOn == null) ? 0 : mergedOn.hashCode();
    return h$;
  }

  static final class Builder extends ChangeNotesState.Builder {
    private ObjectId metaId;
    private Change.Id changeId;
    private ChangeNotesState.ChangeColumns columns;
    private ImmutableSet<String> hashtags;
    private ImmutableList<Map.Entry<String, String>> customKeyedValues;
    private String serverId;
    private ImmutableList<Map.Entry<PatchSet.Id, PatchSet>> patchSets;
    private ImmutableList<Map.Entry<PatchSet.Id, PatchSetApproval>> approvals;
    private ReviewerSet reviewers;
    private ReviewerByEmailSet reviewersByEmail;
    private ReviewerSet pendingReviewers;
    private ReviewerByEmailSet pendingReviewersByEmail;
    private ImmutableList<Account.Id> allPastReviewers;
    private ImmutableList<ReviewerStatusUpdate> reviewerUpdates;
    private ImmutableSet<AttentionSetUpdate> attentionSet;
    private ImmutableList<AttentionSetUpdate> allAttentionSetUpdates;
    private ImmutableList<SubmitRecord> submitRecords;
    private ImmutableList<ChangeMessage> changeMessages;
    private ImmutableListMultimap<ObjectId, HumanComment> publishedComments;
    private ImmutableList<SubmitRequirementResult> submitRequirementsResult;
    private Integer updateCount;
    private Instant mergedOn;
    Builder() {
    }
    @Override
    ChangeNotesState.Builder metaId(ObjectId metaId) {
      this.metaId = metaId;
      return this;
    }
    @Override
    ChangeNotesState.Builder changeId(Change.Id changeId) {
      if (changeId == null) {
        throw new NullPointerException("Null changeId");
      }
      this.changeId = changeId;
      return this;
    }
    @Override
    ChangeNotesState.Builder columns(ChangeNotesState.ChangeColumns columns) {
      this.columns = columns;
      return this;
    }
    @Override
    ChangeNotesState.Builder hashtags(Iterable<String> hashtags) {
      this.hashtags = ImmutableSet.copyOf(hashtags);
      return this;
    }
    @Override
    ChangeNotesState.Builder customKeyedValues(Iterable<Map.Entry<String, String>> customKeyedValues) {
      this.customKeyedValues = ImmutableList.copyOf(customKeyedValues);
      return this;
    }
    @Override
    ChangeNotesState.Builder serverId(String serverId) {
      this.serverId = serverId;
      return this;
    }
    @Override
    ChangeNotesState.Builder patchSets(Iterable<Map.Entry<PatchSet.Id, PatchSet>> patchSets) {
      this.patchSets = ImmutableList.copyOf(patchSets);
      return this;
    }
    @Override
    ChangeNotesState.Builder approvals(Iterable<Map.Entry<PatchSet.Id, PatchSetApproval>> approvals) {
      this.approvals = ImmutableList.copyOf(approvals);
      return this;
    }
    @Override
    ChangeNotesState.Builder reviewers(ReviewerSet reviewers) {
      if (reviewers == null) {
        throw new NullPointerException("Null reviewers");
      }
      this.reviewers = reviewers;
      return this;
    }
    @Override
    ChangeNotesState.Builder reviewersByEmail(ReviewerByEmailSet reviewersByEmail) {
      if (reviewersByEmail == null) {
        throw new NullPointerException("Null reviewersByEmail");
      }
      this.reviewersByEmail = reviewersByEmail;
      return this;
    }
    @Override
    ChangeNotesState.Builder pendingReviewers(ReviewerSet pendingReviewers) {
      if (pendingReviewers == null) {
        throw new NullPointerException("Null pendingReviewers");
      }
      this.pendingReviewers = pendingReviewers;
      return this;
    }
    @Override
    ChangeNotesState.Builder pendingReviewersByEmail(ReviewerByEmailSet pendingReviewersByEmail) {
      if (pendingReviewersByEmail == null) {
        throw new NullPointerException("Null pendingReviewersByEmail");
      }
      this.pendingReviewersByEmail = pendingReviewersByEmail;
      return this;
    }
    @Override
    ChangeNotesState.Builder allPastReviewers(List<Account.Id> allPastReviewers) {
      this.allPastReviewers = ImmutableList.copyOf(allPastReviewers);
      return this;
    }
    @Override
    ChangeNotesState.Builder reviewerUpdates(List<ReviewerStatusUpdate> reviewerUpdates) {
      this.reviewerUpdates = ImmutableList.copyOf(reviewerUpdates);
      return this;
    }
    @Override
    ChangeNotesState.Builder attentionSet(Set<AttentionSetUpdate> attentionSet) {
      this.attentionSet = ImmutableSet.copyOf(attentionSet);
      return this;
    }
    @Override
    ChangeNotesState.Builder allAttentionSetUpdates(List<AttentionSetUpdate> allAttentionSetUpdates) {
      this.allAttentionSetUpdates = ImmutableList.copyOf(allAttentionSetUpdates);
      return this;
    }
    @Override
    ChangeNotesState.Builder submitRecords(List<SubmitRecord> submitRecords) {
      this.submitRecords = ImmutableList.copyOf(submitRecords);
      return this;
    }
    @Override
    ChangeNotesState.Builder changeMessages(List<ChangeMessage> changeMessages) {
      this.changeMessages = ImmutableList.copyOf(changeMessages);
      return this;
    }
    @Override
    ChangeNotesState.Builder publishedComments(ListMultimap<ObjectId, HumanComment> publishedComments) {
      this.publishedComments = ImmutableListMultimap.copyOf(publishedComments);
      return this;
    }
    @Override
    ChangeNotesState.Builder submitRequirementsResult(List<SubmitRequirementResult> submitRequirementsResult) {
      this.submitRequirementsResult = ImmutableList.copyOf(submitRequirementsResult);
      return this;
    }
    @Override
    ChangeNotesState.Builder updateCount(int updateCount) {
      this.updateCount = updateCount;
      return this;
    }
    @Override
    ChangeNotesState.Builder mergedOn(Instant mergedOn) {
      this.mergedOn = mergedOn;
      return this;
    }
    @Override
    ChangeNotesState build() {
      String missing = "";
      if (this.changeId == null) {
        missing += " changeId";
      }
      if (this.hashtags == null) {
        missing += " hashtags";
      }
      if (this.customKeyedValues == null) {
        missing += " customKeyedValues";
      }
      if (this.patchSets == null) {
        missing += " patchSets";
      }
      if (this.approvals == null) {
        missing += " approvals";
      }
      if (this.reviewers == null) {
        missing += " reviewers";
      }
      if (this.reviewersByEmail == null) {
        missing += " reviewersByEmail";
      }
      if (this.pendingReviewers == null) {
        missing += " pendingReviewers";
      }
      if (this.pendingReviewersByEmail == null) {
        missing += " pendingReviewersByEmail";
      }
      if (this.allPastReviewers == null) {
        missing += " allPastReviewers";
      }
      if (this.reviewerUpdates == null) {
        missing += " reviewerUpdates";
      }
      if (this.attentionSet == null) {
        missing += " attentionSet";
      }
      if (this.allAttentionSetUpdates == null) {
        missing += " allAttentionSetUpdates";
      }
      if (this.submitRecords == null) {
        missing += " submitRecords";
      }
      if (this.changeMessages == null) {
        missing += " changeMessages";
      }
      if (this.publishedComments == null) {
        missing += " publishedComments";
      }
      if (this.submitRequirementsResult == null) {
        missing += " submitRequirementsResult";
      }
      if (this.updateCount == null) {
        missing += " updateCount";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ChangeNotesState(
          this.metaId,
          this.changeId,
          this.columns,
          this.hashtags,
          this.customKeyedValues,
          this.serverId,
          this.patchSets,
          this.approvals,
          this.reviewers,
          this.reviewersByEmail,
          this.pendingReviewers,
          this.pendingReviewersByEmail,
          this.allPastReviewers,
          this.reviewerUpdates,
          this.attentionSet,
          this.allAttentionSetUpdates,
          this.submitRecords,
          this.changeMessages,
          this.publishedComments,
          this.submitRequirementsResult,
          this.updateCount,
          this.mergedOn);
    }
  }

}
