package com.google.gerrit.server.patch;

import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GitPositionTransformer_Position extends GitPositionTransformer.Position {

  private final Optional<String> filePath;

  private final Optional<GitPositionTransformer.Range> lineRange;

  private AutoValue_GitPositionTransformer_Position(
      Optional<String> filePath,
      Optional<GitPositionTransformer.Range> lineRange) {
    this.filePath = filePath;
    this.lineRange = lineRange;
  }

  @Override
  public Optional<String> filePath() {
    return filePath;
  }

  @Override
  public Optional<GitPositionTransformer.Range> lineRange() {
    return lineRange;
  }

  @Override
  public String toString() {
    return "Position{"
        + "filePath=" + filePath + ", "
        + "lineRange=" + lineRange
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GitPositionTransformer.Position) {
      GitPositionTransformer.Position that = (GitPositionTransformer.Position) o;
      return this.filePath.equals(that.filePath())
          && this.lineRange.equals(that.lineRange());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= filePath.hashCode();
    h$ *= 1000003;
    h$ ^= lineRange.hashCode();
    return h$;
  }

  @Override
  GitPositionTransformer.Position.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GitPositionTransformer.Position.Builder {
    private Optional<String> filePath = Optional.empty();
    private Optional<GitPositionTransformer.Range> lineRange = Optional.empty();
    Builder() {
    }
    private Builder(GitPositionTransformer.Position source) {
      this.filePath = source.filePath();
      this.lineRange = source.lineRange();
    }
    @Override
    public GitPositionTransformer.Position.Builder filePath(String filePath) {
      this.filePath = Optional.of(filePath);
      return this;
    }
    @Override
    public GitPositionTransformer.Position.Builder lineRange(GitPositionTransformer.Range lineRange) {
      this.lineRange = Optional.of(lineRange);
      return this;
    }
    @Override
    public GitPositionTransformer.Position.Builder lineRange(Optional<GitPositionTransformer.Range> lineRange) {
      if (lineRange == null) {
        throw new NullPointerException("Null lineRange");
      }
      this.lineRange = lineRange;
      return this;
    }
    @Override
    public GitPositionTransformer.Position build() {
      return new AutoValue_GitPositionTransformer_Position(
          this.filePath,
          this.lineRange);
    }
  }

}
