package com.google.gerrit.server.patch.filediff;

import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AugmentedFileDiffCacheKey extends AugmentedFileDiffCacheKey {

  private final FileDiffCacheKey key;

  private final boolean ignoreRebase;

  private final Optional<ObjectId> oldParentId;

  private final Optional<ObjectId> newParentId;

  private AutoValue_AugmentedFileDiffCacheKey(
      FileDiffCacheKey key,
      boolean ignoreRebase,
      Optional<ObjectId> oldParentId,
      Optional<ObjectId> newParentId) {
    this.key = key;
    this.ignoreRebase = ignoreRebase;
    this.oldParentId = oldParentId;
    this.newParentId = newParentId;
  }

  @Override
  FileDiffCacheKey key() {
    return key;
  }

  @Override
  boolean ignoreRebase() {
    return ignoreRebase;
  }

  @Override
  Optional<ObjectId> oldParentId() {
    return oldParentId;
  }

  @Override
  Optional<ObjectId> newParentId() {
    return newParentId;
  }

  @Override
  public String toString() {
    return "AugmentedFileDiffCacheKey{"
        + "key=" + key + ", "
        + "ignoreRebase=" + ignoreRebase + ", "
        + "oldParentId=" + oldParentId + ", "
        + "newParentId=" + newParentId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AugmentedFileDiffCacheKey) {
      AugmentedFileDiffCacheKey that = (AugmentedFileDiffCacheKey) o;
      return this.key.equals(that.key())
          && this.ignoreRebase == that.ignoreRebase()
          && this.oldParentId.equals(that.oldParentId())
          && this.newParentId.equals(that.newParentId());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= ignoreRebase ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= oldParentId.hashCode();
    h$ *= 1000003;
    h$ ^= newParentId.hashCode();
    return h$;
  }

  static final class Builder extends AugmentedFileDiffCacheKey.Builder {
    private FileDiffCacheKey key;
    private Boolean ignoreRebase;
    private Optional<ObjectId> oldParentId = Optional.empty();
    private Optional<ObjectId> newParentId = Optional.empty();
    Builder() {
    }
    @Override
    public AugmentedFileDiffCacheKey.Builder key(FileDiffCacheKey key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    public AugmentedFileDiffCacheKey.Builder ignoreRebase(boolean ignoreRebase) {
      this.ignoreRebase = ignoreRebase;
      return this;
    }
    @Override
    public AugmentedFileDiffCacheKey.Builder oldParentId(Optional<ObjectId> oldParentId) {
      if (oldParentId == null) {
        throw new NullPointerException("Null oldParentId");
      }
      this.oldParentId = oldParentId;
      return this;
    }
    @Override
    public AugmentedFileDiffCacheKey.Builder newParentId(Optional<ObjectId> newParentId) {
      if (newParentId == null) {
        throw new NullPointerException("Null newParentId");
      }
      this.newParentId = newParentId;
      return this;
    }
    @Override
    public AugmentedFileDiffCacheKey build() {
      String missing = "";
      if (this.key == null) {
        missing += " key";
      }
      if (this.ignoreRebase == null) {
        missing += " ignoreRebase";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AugmentedFileDiffCacheKey(
          this.key,
          this.ignoreRebase,
          this.oldParentId,
          this.newParentId);
    }
  }

}
