package com.google.gerrit.server.patch.filediff;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.entities.Patch;
import com.google.gerrit.server.patch.ComparisonType;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_FileDiffOutput extends FileDiffOutput {

  private final ObjectId oldCommitId;

  private final ObjectId newCommitId;

  private final ComparisonType comparisonType;

  private final Optional<String> oldPath;

  private final Optional<String> newPath;

  private final Optional<Patch.FileMode> oldMode;

  private final Optional<Patch.FileMode> newMode;

  private final Patch.ChangeType changeType;

  private final Optional<Patch.PatchType> patchType;

  private final ImmutableList<String> headerLines;

  private final ImmutableList<TaggedEdit> edits;

  private final long size;

  private final long sizeDelta;

  private final Optional<Boolean> negative;

  private AutoValue_FileDiffOutput(
      ObjectId oldCommitId,
      ObjectId newCommitId,
      ComparisonType comparisonType,
      Optional<String> oldPath,
      Optional<String> newPath,
      Optional<Patch.FileMode> oldMode,
      Optional<Patch.FileMode> newMode,
      Patch.ChangeType changeType,
      Optional<Patch.PatchType> patchType,
      ImmutableList<String> headerLines,
      ImmutableList<TaggedEdit> edits,
      long size,
      long sizeDelta,
      Optional<Boolean> negative) {
    this.oldCommitId = oldCommitId;
    this.newCommitId = newCommitId;
    this.comparisonType = comparisonType;
    this.oldPath = oldPath;
    this.newPath = newPath;
    this.oldMode = oldMode;
    this.newMode = newMode;
    this.changeType = changeType;
    this.patchType = patchType;
    this.headerLines = headerLines;
    this.edits = edits;
    this.size = size;
    this.sizeDelta = sizeDelta;
    this.negative = negative;
  }

  @Override
  public ObjectId oldCommitId() {
    return oldCommitId;
  }

  @Override
  public ObjectId newCommitId() {
    return newCommitId;
  }

  @Override
  public ComparisonType comparisonType() {
    return comparisonType;
  }

  @Override
  public Optional<String> oldPath() {
    return oldPath;
  }

  @Override
  public Optional<String> newPath() {
    return newPath;
  }

  @Override
  public Optional<Patch.FileMode> oldMode() {
    return oldMode;
  }

  @Override
  public Optional<Patch.FileMode> newMode() {
    return newMode;
  }

  @Override
  public Patch.ChangeType changeType() {
    return changeType;
  }

  @Override
  public Optional<Patch.PatchType> patchType() {
    return patchType;
  }

  @Override
  public ImmutableList<String> headerLines() {
    return headerLines;
  }

  @Override
  public ImmutableList<TaggedEdit> edits() {
    return edits;
  }

  @Override
  public long size() {
    return size;
  }

  @Override
  public long sizeDelta() {
    return sizeDelta;
  }

  @Override
  public Optional<Boolean> negative() {
    return negative;
  }

  @Override
  public String toString() {
    return "FileDiffOutput{"
        + "oldCommitId=" + oldCommitId + ", "
        + "newCommitId=" + newCommitId + ", "
        + "comparisonType=" + comparisonType + ", "
        + "oldPath=" + oldPath + ", "
        + "newPath=" + newPath + ", "
        + "oldMode=" + oldMode + ", "
        + "newMode=" + newMode + ", "
        + "changeType=" + changeType + ", "
        + "patchType=" + patchType + ", "
        + "headerLines=" + headerLines + ", "
        + "edits=" + edits + ", "
        + "size=" + size + ", "
        + "sizeDelta=" + sizeDelta + ", "
        + "negative=" + negative
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof FileDiffOutput) {
      FileDiffOutput that = (FileDiffOutput) o;
      return this.oldCommitId.equals(that.oldCommitId())
          && this.newCommitId.equals(that.newCommitId())
          && this.comparisonType.equals(that.comparisonType())
          && this.oldPath.equals(that.oldPath())
          && this.newPath.equals(that.newPath())
          && this.oldMode.equals(that.oldMode())
          && this.newMode.equals(that.newMode())
          && this.changeType.equals(that.changeType())
          && this.patchType.equals(that.patchType())
          && this.headerLines.equals(that.headerLines())
          && this.edits.equals(that.edits())
          && this.size == that.size()
          && this.sizeDelta == that.sizeDelta()
          && this.negative.equals(that.negative());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= oldCommitId.hashCode();
    h$ *= 1000003;
    h$ ^= newCommitId.hashCode();
    h$ *= 1000003;
    h$ ^= comparisonType.hashCode();
    h$ *= 1000003;
    h$ ^= oldPath.hashCode();
    h$ *= 1000003;
    h$ ^= newPath.hashCode();
    h$ *= 1000003;
    h$ ^= oldMode.hashCode();
    h$ *= 1000003;
    h$ ^= newMode.hashCode();
    h$ *= 1000003;
    h$ ^= changeType.hashCode();
    h$ *= 1000003;
    h$ ^= patchType.hashCode();
    h$ *= 1000003;
    h$ ^= headerLines.hashCode();
    h$ *= 1000003;
    h$ ^= edits.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((size >>> 32) ^ size);
    h$ *= 1000003;
    h$ ^= (int) ((sizeDelta >>> 32) ^ sizeDelta);
    h$ *= 1000003;
    h$ ^= negative.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 1L;

  @Override
  public FileDiffOutput.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends FileDiffOutput.Builder {
    private ObjectId oldCommitId;
    private ObjectId newCommitId;
    private ComparisonType comparisonType;
    private Optional<String> oldPath = Optional.empty();
    private Optional<String> newPath = Optional.empty();
    private Optional<Patch.FileMode> oldMode = Optional.empty();
    private Optional<Patch.FileMode> newMode = Optional.empty();
    private Patch.ChangeType changeType;
    private Optional<Patch.PatchType> patchType = Optional.empty();
    private ImmutableList<String> headerLines;
    private ImmutableList<TaggedEdit> edits;
    private Long size;
    private Long sizeDelta;
    private Optional<Boolean> negative = Optional.empty();
    Builder() {
    }
    private Builder(FileDiffOutput source) {
      this.oldCommitId = source.oldCommitId();
      this.newCommitId = source.newCommitId();
      this.comparisonType = source.comparisonType();
      this.oldPath = source.oldPath();
      this.newPath = source.newPath();
      this.oldMode = source.oldMode();
      this.newMode = source.newMode();
      this.changeType = source.changeType();
      this.patchType = source.patchType();
      this.headerLines = source.headerLines();
      this.edits = source.edits();
      this.size = source.size();
      this.sizeDelta = source.sizeDelta();
      this.negative = source.negative();
    }
    @Override
    public FileDiffOutput.Builder oldCommitId(ObjectId oldCommitId) {
      if (oldCommitId == null) {
        throw new NullPointerException("Null oldCommitId");
      }
      this.oldCommitId = oldCommitId;
      return this;
    }
    @Override
    public FileDiffOutput.Builder newCommitId(ObjectId newCommitId) {
      if (newCommitId == null) {
        throw new NullPointerException("Null newCommitId");
      }
      this.newCommitId = newCommitId;
      return this;
    }
    @Override
    public FileDiffOutput.Builder comparisonType(ComparisonType comparisonType) {
      if (comparisonType == null) {
        throw new NullPointerException("Null comparisonType");
      }
      this.comparisonType = comparisonType;
      return this;
    }
    @Override
    public FileDiffOutput.Builder oldPath(Optional<String> oldPath) {
      if (oldPath == null) {
        throw new NullPointerException("Null oldPath");
      }
      this.oldPath = oldPath;
      return this;
    }
    @Override
    public FileDiffOutput.Builder newPath(Optional<String> newPath) {
      if (newPath == null) {
        throw new NullPointerException("Null newPath");
      }
      this.newPath = newPath;
      return this;
    }
    @Override
    public FileDiffOutput.Builder oldMode(Optional<Patch.FileMode> oldMode) {
      if (oldMode == null) {
        throw new NullPointerException("Null oldMode");
      }
      this.oldMode = oldMode;
      return this;
    }
    @Override
    public FileDiffOutput.Builder newMode(Optional<Patch.FileMode> newMode) {
      if (newMode == null) {
        throw new NullPointerException("Null newMode");
      }
      this.newMode = newMode;
      return this;
    }
    @Override
    public FileDiffOutput.Builder changeType(Patch.ChangeType changeType) {
      if (changeType == null) {
        throw new NullPointerException("Null changeType");
      }
      this.changeType = changeType;
      return this;
    }
    @Override
    public FileDiffOutput.Builder patchType(Optional<Patch.PatchType> patchType) {
      if (patchType == null) {
        throw new NullPointerException("Null patchType");
      }
      this.patchType = patchType;
      return this;
    }
    @Override
    public FileDiffOutput.Builder headerLines(ImmutableList<String> headerLines) {
      if (headerLines == null) {
        throw new NullPointerException("Null headerLines");
      }
      this.headerLines = headerLines;
      return this;
    }
    @Override
    public FileDiffOutput.Builder edits(ImmutableList<TaggedEdit> edits) {
      if (edits == null) {
        throw new NullPointerException("Null edits");
      }
      this.edits = edits;
      return this;
    }
    @Override
    public FileDiffOutput.Builder size(long size) {
      this.size = size;
      return this;
    }
    @Override
    public FileDiffOutput.Builder sizeDelta(long sizeDelta) {
      this.sizeDelta = sizeDelta;
      return this;
    }
    @Override
    public FileDiffOutput.Builder negative(Optional<Boolean> negative) {
      if (negative == null) {
        throw new NullPointerException("Null negative");
      }
      this.negative = negative;
      return this;
    }
    @Override
    public FileDiffOutput build() {
      String missing = "";
      if (this.oldCommitId == null) {
        missing += " oldCommitId";
      }
      if (this.newCommitId == null) {
        missing += " newCommitId";
      }
      if (this.comparisonType == null) {
        missing += " comparisonType";
      }
      if (this.changeType == null) {
        missing += " changeType";
      }
      if (this.headerLines == null) {
        missing += " headerLines";
      }
      if (this.edits == null) {
        missing += " edits";
      }
      if (this.size == null) {
        missing += " size";
      }
      if (this.sizeDelta == null) {
        missing += " sizeDelta";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_FileDiffOutput(
          this.oldCommitId,
          this.newCommitId,
          this.comparisonType,
          this.oldPath,
          this.newPath,
          this.oldMode,
          this.newMode,
          this.changeType,
          this.patchType,
          this.headerLines,
          this.edits,
          this.size,
          this.sizeDelta,
          this.negative);
    }
  }

}
