package com.google.gerrit.server.patch.gitdiff;

import com.google.gerrit.entities.Project;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GitModifiedFilesCacheKey extends GitModifiedFilesCacheKey {

  private final Project.NameKey project;

  private final ObjectId aTree;

  private final ObjectId bTree;

  private final int renameScore;

  private AutoValue_GitModifiedFilesCacheKey(
      Project.NameKey project,
      ObjectId aTree,
      ObjectId bTree,
      int renameScore) {
    this.project = project;
    this.aTree = aTree;
    this.bTree = bTree;
    this.renameScore = renameScore;
  }

  @Override
  public Project.NameKey project() {
    return project;
  }

  @Override
  public ObjectId aTree() {
    return aTree;
  }

  @Override
  public ObjectId bTree() {
    return bTree;
  }

  @Override
  public int renameScore() {
    return renameScore;
  }

  @Override
  public String toString() {
    return "GitModifiedFilesCacheKey{"
        + "project=" + project + ", "
        + "aTree=" + aTree + ", "
        + "bTree=" + bTree + ", "
        + "renameScore=" + renameScore
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GitModifiedFilesCacheKey) {
      GitModifiedFilesCacheKey that = (GitModifiedFilesCacheKey) o;
      return this.project.equals(that.project())
          && this.aTree.equals(that.aTree())
          && this.bTree.equals(that.bTree())
          && this.renameScore == that.renameScore();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= aTree.hashCode();
    h$ *= 1000003;
    h$ ^= bTree.hashCode();
    h$ *= 1000003;
    h$ ^= renameScore;
    return h$;
  }

  static final class Builder extends GitModifiedFilesCacheKey.Builder {
    private Project.NameKey project;
    private ObjectId aTree;
    private ObjectId bTree;
    private Integer renameScore;
    Builder() {
    }
    @Override
    public GitModifiedFilesCacheKey.Builder project(Project.NameKey project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public GitModifiedFilesCacheKey.Builder aTree(ObjectId aTree) {
      if (aTree == null) {
        throw new NullPointerException("Null aTree");
      }
      this.aTree = aTree;
      return this;
    }
    @Override
    public GitModifiedFilesCacheKey.Builder bTree(ObjectId bTree) {
      if (bTree == null) {
        throw new NullPointerException("Null bTree");
      }
      this.bTree = bTree;
      return this;
    }
    @Override
    public GitModifiedFilesCacheKey.Builder renameScore(int renameScore) {
      this.renameScore = renameScore;
      return this;
    }
    @Override
    public GitModifiedFilesCacheKey build() {
      String missing = "";
      if (this.project == null) {
        missing += " project";
      }
      if (this.aTree == null) {
        missing += " aTree";
      }
      if (this.bTree == null) {
        missing += " bTree";
      }
      if (this.renameScore == null) {
        missing += " renameScore";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GitModifiedFilesCacheKey(
          this.project,
          this.aTree,
          this.bTree,
          this.renameScore);
    }
  }

}
