package com.google.gerrit.server.patch.gitdiff;

import com.google.gerrit.entities.Patch;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ModifiedFile extends ModifiedFile {

  private final Patch.ChangeType changeType;

  private final Optional<String> oldPath;

  private final Optional<String> newPath;

  private AutoValue_ModifiedFile(
      Patch.ChangeType changeType,
      Optional<String> oldPath,
      Optional<String> newPath) {
    this.changeType = changeType;
    this.oldPath = oldPath;
    this.newPath = newPath;
  }

  @Override
  public Patch.ChangeType changeType() {
    return changeType;
  }

  @Override
  public Optional<String> oldPath() {
    return oldPath;
  }

  @Override
  public Optional<String> newPath() {
    return newPath;
  }

  @Override
  public String toString() {
    return "ModifiedFile{"
        + "changeType=" + changeType + ", "
        + "oldPath=" + oldPath + ", "
        + "newPath=" + newPath
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ModifiedFile) {
      ModifiedFile that = (ModifiedFile) o;
      return this.changeType.equals(that.changeType())
          && this.oldPath.equals(that.oldPath())
          && this.newPath.equals(that.newPath());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= changeType.hashCode();
    h$ *= 1000003;
    h$ ^= oldPath.hashCode();
    h$ *= 1000003;
    h$ ^= newPath.hashCode();
    return h$;
  }

  @Override
  public ModifiedFile.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ModifiedFile.Builder {
    private Patch.ChangeType changeType;
    private Optional<String> oldPath = Optional.empty();
    private Optional<String> newPath = Optional.empty();
    Builder() {
    }
    private Builder(ModifiedFile source) {
      this.changeType = source.changeType();
      this.oldPath = source.oldPath();
      this.newPath = source.newPath();
    }
    @Override
    public ModifiedFile.Builder changeType(Patch.ChangeType changeType) {
      if (changeType == null) {
        throw new NullPointerException("Null changeType");
      }
      this.changeType = changeType;
      return this;
    }
    @Override
    public ModifiedFile.Builder oldPath(Optional<String> oldPath) {
      if (oldPath == null) {
        throw new NullPointerException("Null oldPath");
      }
      this.oldPath = oldPath;
      return this;
    }
    @Override
    public ModifiedFile.Builder newPath(Optional<String> newPath) {
      if (newPath == null) {
        throw new NullPointerException("Null newPath");
      }
      this.newPath = newPath;
      return this;
    }
    @Override
    public ModifiedFile build() {
      String missing = "";
      if (this.changeType == null) {
        missing += " changeType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ModifiedFile(
          this.changeType,
          this.oldPath,
          this.newPath);
    }
  }

}
