package com.google.gerrit.server.patch.gitfilediff;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.entities.Patch;
import com.google.gerrit.server.patch.filediff.Edit;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.AbbreviatedObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GitFileDiff extends GitFileDiff {

  private final ImmutableList<Edit> edits;

  private final String fileHeader;

  private final Optional<String> oldPath;

  private final Optional<String> newPath;

  private final AbbreviatedObjectId oldId;

  private final AbbreviatedObjectId newId;

  private final Optional<Patch.FileMode> oldMode;

  private final Optional<Patch.FileMode> newMode;

  private final Patch.ChangeType changeType;

  private final Optional<Patch.PatchType> patchType;

  private final Optional<Boolean> negative;

  private AutoValue_GitFileDiff(
      ImmutableList<Edit> edits,
      String fileHeader,
      Optional<String> oldPath,
      Optional<String> newPath,
      AbbreviatedObjectId oldId,
      AbbreviatedObjectId newId,
      Optional<Patch.FileMode> oldMode,
      Optional<Patch.FileMode> newMode,
      Patch.ChangeType changeType,
      Optional<Patch.PatchType> patchType,
      Optional<Boolean> negative) {
    this.edits = edits;
    this.fileHeader = fileHeader;
    this.oldPath = oldPath;
    this.newPath = newPath;
    this.oldId = oldId;
    this.newId = newId;
    this.oldMode = oldMode;
    this.newMode = newMode;
    this.changeType = changeType;
    this.patchType = patchType;
    this.negative = negative;
  }

  @Override
  public ImmutableList<Edit> edits() {
    return edits;
  }

  @Override
  public String fileHeader() {
    return fileHeader;
  }

  @Override
  public Optional<String> oldPath() {
    return oldPath;
  }

  @Override
  public Optional<String> newPath() {
    return newPath;
  }

  @Override
  public AbbreviatedObjectId oldId() {
    return oldId;
  }

  @Override
  public AbbreviatedObjectId newId() {
    return newId;
  }

  @Override
  public Optional<Patch.FileMode> oldMode() {
    return oldMode;
  }

  @Override
  public Optional<Patch.FileMode> newMode() {
    return newMode;
  }

  @Override
  public Patch.ChangeType changeType() {
    return changeType;
  }

  @Override
  public Optional<Patch.PatchType> patchType() {
    return patchType;
  }

  @Override
  public Optional<Boolean> negative() {
    return negative;
  }

  @Override
  public String toString() {
    return "GitFileDiff{"
        + "edits=" + edits + ", "
        + "fileHeader=" + fileHeader + ", "
        + "oldPath=" + oldPath + ", "
        + "newPath=" + newPath + ", "
        + "oldId=" + oldId + ", "
        + "newId=" + newId + ", "
        + "oldMode=" + oldMode + ", "
        + "newMode=" + newMode + ", "
        + "changeType=" + changeType + ", "
        + "patchType=" + patchType + ", "
        + "negative=" + negative
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GitFileDiff) {
      GitFileDiff that = (GitFileDiff) o;
      return this.edits.equals(that.edits())
          && this.fileHeader.equals(that.fileHeader())
          && this.oldPath.equals(that.oldPath())
          && this.newPath.equals(that.newPath())
          && this.oldId.equals(that.oldId())
          && this.newId.equals(that.newId())
          && this.oldMode.equals(that.oldMode())
          && this.newMode.equals(that.newMode())
          && this.changeType.equals(that.changeType())
          && this.patchType.equals(that.patchType())
          && this.negative.equals(that.negative());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= edits.hashCode();
    h$ *= 1000003;
    h$ ^= fileHeader.hashCode();
    h$ *= 1000003;
    h$ ^= oldPath.hashCode();
    h$ *= 1000003;
    h$ ^= newPath.hashCode();
    h$ *= 1000003;
    h$ ^= oldId.hashCode();
    h$ *= 1000003;
    h$ ^= newId.hashCode();
    h$ *= 1000003;
    h$ ^= oldMode.hashCode();
    h$ *= 1000003;
    h$ ^= newMode.hashCode();
    h$ *= 1000003;
    h$ ^= changeType.hashCode();
    h$ *= 1000003;
    h$ ^= patchType.hashCode();
    h$ *= 1000003;
    h$ ^= negative.hashCode();
    return h$;
  }

  @Override
  public GitFileDiff.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GitFileDiff.Builder {
    private ImmutableList<Edit> edits;
    private String fileHeader;
    private Optional<String> oldPath = Optional.empty();
    private Optional<String> newPath = Optional.empty();
    private AbbreviatedObjectId oldId;
    private AbbreviatedObjectId newId;
    private Optional<Patch.FileMode> oldMode = Optional.empty();
    private Optional<Patch.FileMode> newMode = Optional.empty();
    private Patch.ChangeType changeType;
    private Optional<Patch.PatchType> patchType = Optional.empty();
    private Optional<Boolean> negative = Optional.empty();
    Builder() {
    }
    private Builder(GitFileDiff source) {
      this.edits = source.edits();
      this.fileHeader = source.fileHeader();
      this.oldPath = source.oldPath();
      this.newPath = source.newPath();
      this.oldId = source.oldId();
      this.newId = source.newId();
      this.oldMode = source.oldMode();
      this.newMode = source.newMode();
      this.changeType = source.changeType();
      this.patchType = source.patchType();
      this.negative = source.negative();
    }
    @Override
    public GitFileDiff.Builder edits(ImmutableList<Edit> edits) {
      if (edits == null) {
        throw new NullPointerException("Null edits");
      }
      this.edits = edits;
      return this;
    }
    @Override
    public GitFileDiff.Builder fileHeader(String fileHeader) {
      if (fileHeader == null) {
        throw new NullPointerException("Null fileHeader");
      }
      this.fileHeader = fileHeader;
      return this;
    }
    @Override
    public GitFileDiff.Builder oldPath(Optional<String> oldPath) {
      if (oldPath == null) {
        throw new NullPointerException("Null oldPath");
      }
      this.oldPath = oldPath;
      return this;
    }
    @Override
    public GitFileDiff.Builder newPath(Optional<String> newPath) {
      if (newPath == null) {
        throw new NullPointerException("Null newPath");
      }
      this.newPath = newPath;
      return this;
    }
    @Override
    public GitFileDiff.Builder oldId(AbbreviatedObjectId oldId) {
      if (oldId == null) {
        throw new NullPointerException("Null oldId");
      }
      this.oldId = oldId;
      return this;
    }
    @Override
    public GitFileDiff.Builder newId(AbbreviatedObjectId newId) {
      if (newId == null) {
        throw new NullPointerException("Null newId");
      }
      this.newId = newId;
      return this;
    }
    @Override
    public GitFileDiff.Builder oldMode(Optional<Patch.FileMode> oldMode) {
      if (oldMode == null) {
        throw new NullPointerException("Null oldMode");
      }
      this.oldMode = oldMode;
      return this;
    }
    @Override
    public GitFileDiff.Builder newMode(Optional<Patch.FileMode> newMode) {
      if (newMode == null) {
        throw new NullPointerException("Null newMode");
      }
      this.newMode = newMode;
      return this;
    }
    @Override
    public GitFileDiff.Builder changeType(Patch.ChangeType changeType) {
      if (changeType == null) {
        throw new NullPointerException("Null changeType");
      }
      this.changeType = changeType;
      return this;
    }
    @Override
    public GitFileDiff.Builder patchType(Optional<Patch.PatchType> patchType) {
      if (patchType == null) {
        throw new NullPointerException("Null patchType");
      }
      this.patchType = patchType;
      return this;
    }
    @Override
    public GitFileDiff.Builder negative(Optional<Boolean> negative) {
      if (negative == null) {
        throw new NullPointerException("Null negative");
      }
      this.negative = negative;
      return this;
    }
    @Override
    public GitFileDiff build() {
      String missing = "";
      if (this.edits == null) {
        missing += " edits";
      }
      if (this.fileHeader == null) {
        missing += " fileHeader";
      }
      if (this.oldId == null) {
        missing += " oldId";
      }
      if (this.newId == null) {
        missing += " newId";
      }
      if (this.changeType == null) {
        missing += " changeType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GitFileDiff(
          this.edits,
          this.fileHeader,
          this.oldPath,
          this.newPath,
          this.oldId,
          this.newId,
          this.oldMode,
          this.newMode,
          this.changeType,
          this.patchType,
          this.negative);
    }
  }

}
