package com.google.gerrit.server.patch.gitfilediff;

import com.google.gerrit.entities.Project;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GitFileDiffCacheKey extends GitFileDiffCacheKey {

  private final Project.NameKey project;

  private final ObjectId oldTree;

  private final ObjectId newTree;

  private final String newFilePath;

  private final int renameScore;

  private final GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm;

  private final DiffPreferencesInfo.Whitespace whitespace;

  private final boolean useTimeout;

  private AutoValue_GitFileDiffCacheKey(
      Project.NameKey project,
      ObjectId oldTree,
      ObjectId newTree,
      String newFilePath,
      int renameScore,
      GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm,
      DiffPreferencesInfo.Whitespace whitespace,
      boolean useTimeout) {
    this.project = project;
    this.oldTree = oldTree;
    this.newTree = newTree;
    this.newFilePath = newFilePath;
    this.renameScore = renameScore;
    this.diffAlgorithm = diffAlgorithm;
    this.whitespace = whitespace;
    this.useTimeout = useTimeout;
  }

  @Override
  public Project.NameKey project() {
    return project;
  }

  @Override
  public ObjectId oldTree() {
    return oldTree;
  }

  @Override
  public ObjectId newTree() {
    return newTree;
  }

  @Override
  public String newFilePath() {
    return newFilePath;
  }

  @Override
  public int renameScore() {
    return renameScore;
  }

  @Override
  public GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm() {
    return diffAlgorithm;
  }

  @Override
  public DiffPreferencesInfo.Whitespace whitespace() {
    return whitespace;
  }

  @Override
  public boolean useTimeout() {
    return useTimeout;
  }

  @Override
  public String toString() {
    return "GitFileDiffCacheKey{"
        + "project=" + project + ", "
        + "oldTree=" + oldTree + ", "
        + "newTree=" + newTree + ", "
        + "newFilePath=" + newFilePath + ", "
        + "renameScore=" + renameScore + ", "
        + "diffAlgorithm=" + diffAlgorithm + ", "
        + "whitespace=" + whitespace + ", "
        + "useTimeout=" + useTimeout
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GitFileDiffCacheKey) {
      GitFileDiffCacheKey that = (GitFileDiffCacheKey) o;
      return this.project.equals(that.project())
          && this.oldTree.equals(that.oldTree())
          && this.newTree.equals(that.newTree())
          && this.newFilePath.equals(that.newFilePath())
          && this.renameScore == that.renameScore()
          && this.diffAlgorithm.equals(that.diffAlgorithm())
          && this.whitespace.equals(that.whitespace())
          && this.useTimeout == that.useTimeout();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= oldTree.hashCode();
    h$ *= 1000003;
    h$ ^= newTree.hashCode();
    h$ *= 1000003;
    h$ ^= newFilePath.hashCode();
    h$ *= 1000003;
    h$ ^= renameScore;
    h$ *= 1000003;
    h$ ^= diffAlgorithm.hashCode();
    h$ *= 1000003;
    h$ ^= whitespace.hashCode();
    h$ *= 1000003;
    h$ ^= useTimeout ? 1231 : 1237;
    return h$;
  }

  static final class Builder extends GitFileDiffCacheKey.Builder {
    private Project.NameKey project;
    private ObjectId oldTree;
    private ObjectId newTree;
    private String newFilePath;
    private Integer renameScore;
    private GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm;
    private DiffPreferencesInfo.Whitespace whitespace;
    private Boolean useTimeout;
    Builder() {
    }
    @Override
    public GitFileDiffCacheKey.Builder project(Project.NameKey project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public GitFileDiffCacheKey.Builder oldTree(ObjectId oldTree) {
      if (oldTree == null) {
        throw new NullPointerException("Null oldTree");
      }
      this.oldTree = oldTree;
      return this;
    }
    @Override
    public GitFileDiffCacheKey.Builder newTree(ObjectId newTree) {
      if (newTree == null) {
        throw new NullPointerException("Null newTree");
      }
      this.newTree = newTree;
      return this;
    }
    @Override
    public GitFileDiffCacheKey.Builder newFilePath(String newFilePath) {
      if (newFilePath == null) {
        throw new NullPointerException("Null newFilePath");
      }
      this.newFilePath = newFilePath;
      return this;
    }
    @Override
    public GitFileDiffCacheKey.Builder renameScore(Integer renameScore) {
      if (renameScore == null) {
        throw new NullPointerException("Null renameScore");
      }
      this.renameScore = renameScore;
      return this;
    }
    @Override
    public GitFileDiffCacheKey.Builder diffAlgorithm(GitFileDiffCacheImpl.DiffAlgorithm diffAlgorithm) {
      if (diffAlgorithm == null) {
        throw new NullPointerException("Null diffAlgorithm");
      }
      this.diffAlgorithm = diffAlgorithm;
      return this;
    }
    @Override
    public GitFileDiffCacheKey.Builder whitespace(DiffPreferencesInfo.Whitespace whitespace) {
      if (whitespace == null) {
        throw new NullPointerException("Null whitespace");
      }
      this.whitespace = whitespace;
      return this;
    }
    @Override
    public GitFileDiffCacheKey.Builder useTimeout(boolean useTimeout) {
      this.useTimeout = useTimeout;
      return this;
    }
    @Override
    public GitFileDiffCacheKey build() {
      String missing = "";
      if (this.project == null) {
        missing += " project";
      }
      if (this.oldTree == null) {
        missing += " oldTree";
      }
      if (this.newTree == null) {
        missing += " newTree";
      }
      if (this.newFilePath == null) {
        missing += " newFilePath";
      }
      if (this.renameScore == null) {
        missing += " renameScore";
      }
      if (this.diffAlgorithm == null) {
        missing += " diffAlgorithm";
      }
      if (this.whitespace == null) {
        missing += " whitespace";
      }
      if (this.useTimeout == null) {
        missing += " useTimeout";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GitFileDiffCacheKey(
          this.project,
          this.oldTree,
          this.newTree,
          this.newFilePath,
          this.renameScore,
          this.diffAlgorithm,
          this.whitespace,
          this.useTimeout);
    }
  }

}
