package com.google.gerrit.server.query.approval;

import com.google.gerrit.entities.Account;
import com.google.gerrit.entities.LabelType;
import com.google.gerrit.entities.PatchSet;
import com.google.gerrit.extensions.client.ChangeKind;
import com.google.gerrit.server.notedb.ChangeNotes;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.revwalk.RevWalk;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ApprovalContext extends ApprovalContext {

  private final PatchSet.Id sourcePatchSetId;

  private final Account.Id approverId;

  private final LabelType labelType;

  private final short approvalValue;

  private final PatchSet targetPatchSet;

  private final ChangeNotes changeNotes;

  private final ChangeKind changeKind;

  private final boolean isMerge;

  private final RevWalk revWalk;

  private final Config repoConfig;

  AutoValue_ApprovalContext(
      PatchSet.Id sourcePatchSetId,
      Account.Id approverId,
      LabelType labelType,
      short approvalValue,
      PatchSet targetPatchSet,
      ChangeNotes changeNotes,
      ChangeKind changeKind,
      boolean isMerge,
      RevWalk revWalk,
      Config repoConfig) {
    if (sourcePatchSetId == null) {
      throw new NullPointerException("Null sourcePatchSetId");
    }
    this.sourcePatchSetId = sourcePatchSetId;
    if (approverId == null) {
      throw new NullPointerException("Null approverId");
    }
    this.approverId = approverId;
    if (labelType == null) {
      throw new NullPointerException("Null labelType");
    }
    this.labelType = labelType;
    this.approvalValue = approvalValue;
    if (targetPatchSet == null) {
      throw new NullPointerException("Null targetPatchSet");
    }
    this.targetPatchSet = targetPatchSet;
    if (changeNotes == null) {
      throw new NullPointerException("Null changeNotes");
    }
    this.changeNotes = changeNotes;
    if (changeKind == null) {
      throw new NullPointerException("Null changeKind");
    }
    this.changeKind = changeKind;
    this.isMerge = isMerge;
    if (revWalk == null) {
      throw new NullPointerException("Null revWalk");
    }
    this.revWalk = revWalk;
    if (repoConfig == null) {
      throw new NullPointerException("Null repoConfig");
    }
    this.repoConfig = repoConfig;
  }

  @Override
  public PatchSet.Id sourcePatchSetId() {
    return sourcePatchSetId;
  }

  @Override
  public Account.Id approverId() {
    return approverId;
  }

  @Override
  public LabelType labelType() {
    return labelType;
  }

  @Override
  public short approvalValue() {
    return approvalValue;
  }

  @Override
  public PatchSet targetPatchSet() {
    return targetPatchSet;
  }

  @Override
  public ChangeNotes changeNotes() {
    return changeNotes;
  }

  @Override
  public ChangeKind changeKind() {
    return changeKind;
  }

  @Override
  public boolean isMerge() {
    return isMerge;
  }

  @Override
  public RevWalk revWalk() {
    return revWalk;
  }

  @Override
  public Config repoConfig() {
    return repoConfig;
  }

  @Override
  public String toString() {
    return "ApprovalContext{"
        + "sourcePatchSetId=" + sourcePatchSetId + ", "
        + "approverId=" + approverId + ", "
        + "labelType=" + labelType + ", "
        + "approvalValue=" + approvalValue + ", "
        + "targetPatchSet=" + targetPatchSet + ", "
        + "changeNotes=" + changeNotes + ", "
        + "changeKind=" + changeKind + ", "
        + "isMerge=" + isMerge + ", "
        + "revWalk=" + revWalk + ", "
        + "repoConfig=" + repoConfig
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ApprovalContext) {
      ApprovalContext that = (ApprovalContext) o;
      return this.sourcePatchSetId.equals(that.sourcePatchSetId())
          && this.approverId.equals(that.approverId())
          && this.labelType.equals(that.labelType())
          && this.approvalValue == that.approvalValue()
          && this.targetPatchSet.equals(that.targetPatchSet())
          && this.changeNotes.equals(that.changeNotes())
          && this.changeKind.equals(that.changeKind())
          && this.isMerge == that.isMerge()
          && this.revWalk.equals(that.revWalk())
          && this.repoConfig.equals(that.repoConfig());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= sourcePatchSetId.hashCode();
    h$ *= 1000003;
    h$ ^= approverId.hashCode();
    h$ *= 1000003;
    h$ ^= labelType.hashCode();
    h$ *= 1000003;
    h$ ^= approvalValue;
    h$ *= 1000003;
    h$ ^= targetPatchSet.hashCode();
    h$ *= 1000003;
    h$ ^= changeNotes.hashCode();
    h$ *= 1000003;
    h$ ^= changeKind.hashCode();
    h$ *= 1000003;
    h$ ^= isMerge ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= revWalk.hashCode();
    h$ *= 1000003;
    h$ ^= repoConfig.hashCode();
    return h$;
  }

}
