package com.google.gerrit.server.restapi.change;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.entities.Change;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CherryPickChange_Result extends CherryPickChange.Result {

  private final Change.Id changeId;

  private final ImmutableSet<String> filesWithGitConflicts;

  AutoValue_CherryPickChange_Result(
      Change.Id changeId,
      ImmutableSet<String> filesWithGitConflicts) {
    if (changeId == null) {
      throw new NullPointerException("Null changeId");
    }
    this.changeId = changeId;
    if (filesWithGitConflicts == null) {
      throw new NullPointerException("Null filesWithGitConflicts");
    }
    this.filesWithGitConflicts = filesWithGitConflicts;
  }

  @Override
  Change.Id changeId() {
    return changeId;
  }

  @Override
  ImmutableSet<String> filesWithGitConflicts() {
    return filesWithGitConflicts;
  }

  @Override
  public String toString() {
    return "Result{"
        + "changeId=" + changeId + ", "
        + "filesWithGitConflicts=" + filesWithGitConflicts
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CherryPickChange.Result) {
      CherryPickChange.Result that = (CherryPickChange.Result) o;
      return this.changeId.equals(that.changeId())
          && this.filesWithGitConflicts.equals(that.filesWithGitConflicts());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= changeId.hashCode();
    h$ *= 1000003;
    h$ ^= filesWithGitConflicts.hashCode();
    return h$;
  }

}
