package com.google.gerrit.server.restapi.change;

import com.google.common.hash.HashCode;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.entities.Comment;
import com.google.gerrit.extensions.client.Side;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PostReview_CommentSetEntry extends PostReview.CommentSetEntry {

  private final String filename;

  private final int patchSetId;

  private final Integer line;

  private final Side side;

  private final HashCode message;

  private final Comment.Range range;

  AutoValue_PostReview_CommentSetEntry(
      String filename,
      int patchSetId,
      @Nullable Integer line,
      Side side,
      HashCode message,
      @Nullable Comment.Range range) {
    if (filename == null) {
      throw new NullPointerException("Null filename");
    }
    this.filename = filename;
    this.patchSetId = patchSetId;
    this.line = line;
    if (side == null) {
      throw new NullPointerException("Null side");
    }
    this.side = side;
    if (message == null) {
      throw new NullPointerException("Null message");
    }
    this.message = message;
    this.range = range;
  }

  @Override
  String filename() {
    return filename;
  }

  @Override
  int patchSetId() {
    return patchSetId;
  }

  @Nullable
  @Override
  Integer line() {
    return line;
  }

  @Override
  Side side() {
    return side;
  }

  @Override
  HashCode message() {
    return message;
  }

  @Nullable
  @Override
  Comment.Range range() {
    return range;
  }

  @Override
  public String toString() {
    return "CommentSetEntry{"
        + "filename=" + filename + ", "
        + "patchSetId=" + patchSetId + ", "
        + "line=" + line + ", "
        + "side=" + side + ", "
        + "message=" + message + ", "
        + "range=" + range
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PostReview.CommentSetEntry) {
      PostReview.CommentSetEntry that = (PostReview.CommentSetEntry) o;
      return this.filename.equals(that.filename())
          && this.patchSetId == that.patchSetId()
          && (this.line == null ? that.line() == null : this.line.equals(that.line()))
          && this.side.equals(that.side())
          && this.message.equals(that.message())
          && (this.range == null ? that.range() == null : this.range.equals(that.range()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= filename.hashCode();
    h$ *= 1000003;
    h$ ^= patchSetId;
    h$ *= 1000003;
    h$ ^= (line == null) ? 0 : line.hashCode();
    h$ *= 1000003;
    h$ ^= side.hashCode();
    h$ *= 1000003;
    h$ ^= message.hashCode();
    h$ *= 1000003;
    h$ ^= (range == null) ? 0 : range.hashCode();
    return h$;
  }

}
