/*
 * Decompiled with CFR 0.152.
 */
import com.google.gerrit.launcher.GerritLauncher;

public final class Main {
    private static final String FLOGGER_BACKEND_PROPERTY = "flogger.backend_factory";
    private static final String FLOGGER_LOGGING_CONTEXT = "flogger.logging_context";
    private static final Runtime.Version MIN_JAVA_VERSION = Runtime.Version.parse("11.0.10");

    public static void main(String[] argv) throws Exception {
        if (Main.onSupportedJavaVersion()) {
            Main.configureFloggerBackend();
            GerritLauncher.main(argv);
        } else {
            System.exit(1);
        }
    }

    private static boolean onSupportedJavaVersion() {
        Runtime.Version version = Runtime.version();
        if (version.compareTo(MIN_JAVA_VERSION) >= 0) {
            return true;
        }
        System.err.println("fatal: Gerrit Code Review requires Java " + MIN_JAVA_VERSION + " or later");
        System.err.println("       (trying to run on Java " + version + ")");
        return false;
    }

    private static void configureFloggerBackend() {
        System.setProperty(FLOGGER_LOGGING_CONTEXT, "com.google.gerrit.server.logging.LoggingContext#getInstance");
        if (System.getProperty(FLOGGER_BACKEND_PROPERTY) != null) {
            return;
        }
        System.setProperty(FLOGGER_BACKEND_PROPERTY, "com.google.common.flogger.backend.log4j.Log4jBackendFactory#getInstance");
    }

    private Main() {
    }
}

