/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class GerritLauncher {
    private static final String PKG = "com.google.gerrit.pgm";
    public static final String NOT_ARCHIVED = "NOT_ARCHIVED";
    private static ClassLoader daemonClassLoader;
    private static volatile File myArchive;
    private static volatile File myHome;
    private static final Map<Path, FileSystem> zipFileSystems;
    private static boolean temporaryDirectoryFound;
    private static File temporaryDirectory;
    static final String SOURCE_ROOT_RESOURCE = "/com/google/gerrit/launcher/workspace-root.txt";

    public static void main(String[] argv) throws Exception {
        System.exit(GerritLauncher.mainImpl(argv));
    }

    public static int mainImpl(String[] argv) throws Exception {
        if (argv.length == 0 || "-h".equals(argv[0]) || "--help".equals(argv[0])) {
            File me;
            try {
                me = GerritLauncher.getDistributionArchive();
            }
            catch (FileNotFoundException e) {
                me = null;
            }
            String jar = me != null ? me.getName() : "gerrit.war";
            System.err.println("Gerrit Code Review " + GerritLauncher.getVersion(me));
            System.err.println("usage: java -jar " + jar + " command [ARG ...]");
            System.err.println();
            System.err.println("The most commonly used commands are:");
            System.err.println("  init            Initialize a Gerrit installation");
            System.err.println("  reindex         Rebuild the secondary index");
            System.err.println("  daemon          Run the Gerrit network daemons");
            System.err.println("  version         Display the build version number");
            System.err.println("  passwd          Set or change password in secure.config");
            System.err.println();
            System.err.println("  ls              List files available for cat");
            System.err.println("  cat FILE        Display a file from the archive");
            System.err.println();
            return 1;
        }
        if ("-v".equals(argv[0]) || "--version".equals(argv[0])) {
            argv[0] = "version";
        } else if ("-p".equals(argv[0]) || "--cat".equals(argv[0])) {
            argv[0] = "cat";
        } else if ("-l".equals(argv[0]) || "--ls".equals(argv[0])) {
            argv[0] = "ls";
        }
        ClassLoader cl = GerritLauncher.libClassLoader(GerritLauncher.isProlog(GerritLauncher.programClassName(argv[0])));
        Thread.currentThread().setContextClassLoader(cl);
        return GerritLauncher.invokeProgram(cl, argv);
    }

    public static void daemonStart(String[] argv) throws Exception {
        if (daemonClassLoader != null) {
            throw new IllegalStateException("daemonStart can be called only once per JVM instance");
        }
        ClassLoader cl = GerritLauncher.libClassLoader(false);
        Thread.currentThread().setContextClassLoader(cl);
        daemonClassLoader = cl;
        String[] daemonArgv = new String[argv.length + 1];
        daemonArgv[0] = "daemon";
        for (int i = 0; i < argv.length; ++i) {
            daemonArgv[i + 1] = argv[i];
        }
        int res = GerritLauncher.invokeProgram(cl, daemonArgv);
        if (res != 0) {
            throw new Exception("Unexpected return value: " + res);
        }
    }

    public static void daemonStop(String[] argv) throws Exception {
        if (daemonClassLoader == null) {
            throw new IllegalStateException("daemonStop can be called only after call to daemonStop");
        }
        String[] daemonArgv = new String[argv.length + 2];
        daemonArgv[0] = "daemon";
        daemonArgv[1] = "--stop-only";
        for (int i = 0; i < argv.length; ++i) {
            daemonArgv[i + 2] = argv[i];
        }
        int res = GerritLauncher.invokeProgram(daemonClassLoader, daemonArgv);
        if (res != 0) {
            throw new Exception("Unexpected return value: " + res);
        }
    }

    private static boolean isProlog(String cn) {
        return "PrologShell".equals(cn) || "Rulec".equals(cn);
    }

    private static String getVersion(File me) {
        String string;
        if (me == null) {
            return "";
        }
        JarFile jar = new JarFile(me);
        try {
            Manifest mf = jar.getManifest();
            Attributes att = mf.getMainAttributes();
            String val = att.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string = val != null ? val : "";
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "";
            }
        }
        jar.close();
        return string;
    }

    public static int invokeProgram(ClassLoader loader, String[] origArgv) throws Exception {
        Object res;
        Method main;
        Class<?> clazz;
        String[] argv;
        String name;
        block12: {
            name = origArgv[0];
            argv = new String[origArgv.length - 1];
            System.arraycopy(origArgv, 1, argv, 0, argv.length);
            try {
                try {
                    String cn = GerritLauncher.programClassName(name);
                    clazz = Class.forName("com.google.gerrit.pgm." + cn, true, loader);
                }
                catch (ClassNotFoundException cnfe) {
                    if (name.equals(name.toLowerCase())) {
                        clazz = Class.forName("com.google.gerrit.pgm." + name, true, loader);
                        break block12;
                    }
                    throw cnfe;
                }
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("fatal: unknown command " + name);
                System.err.println("      (no com.google.gerrit.pgm." + name + ")");
                return 1;
            }
        }
        try {
            main = clazz.getMethod("main", argv.getClass());
        }
        catch (NoSuchMethodException | SecurityException e) {
            System.err.println("fatal: unknown command " + name);
            return 1;
        }
        try {
            res = (main.getModifiers() & 8) == 8 ? main.invoke(null, new Object[]{argv}) : main.invoke(clazz.getConstructor(new Class[0]).newInstance(new Object[0]), new Object[]{argv});
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof Exception) {
                throw (Exception)ite.getCause();
            }
            if (ite.getCause() instanceof Error) {
                throw (Error)ite.getCause();
            }
            throw ite;
        }
        if (res instanceof Number) {
            return ((Number)res).intValue();
        }
        return 0;
    }

    private static String programClassName(String cn) {
        if (cn.equals(cn.toLowerCase())) {
            StringBuilder buf = new StringBuilder();
            buf.append(Character.toUpperCase(cn.charAt(0)));
            for (int i = 1; i < cn.length(); ++i) {
                if (cn.charAt(i) == '-' && i + 1 < cn.length()) {
                    buf.append(Character.toUpperCase(cn.charAt(++i)));
                    continue;
                }
                buf.append(cn.charAt(i));
            }
            return buf.toString();
        }
        return cn;
    }

    private static ClassLoader libClassLoader(boolean prologCompiler) throws IOException {
        File path;
        try {
            path = GerritLauncher.getDistributionArchive();
        }
        catch (FileNotFoundException e) {
            if (NOT_ARCHIVED.equals(e.getMessage())) {
                return GerritLauncher.useDevClasspath();
            }
            throw e;
        }
        TreeMap<String, URL> jars = new TreeMap<String, URL>();
        try (ZipFile zf = new ZipFile(path);){
            Iterator zipEntryIt = zf.stream().iterator();
            while (zipEntryIt.hasNext()) {
                ZipEntry ze = (ZipEntry)zipEntryIt.next();
                if (ze.isDirectory()) continue;
                String name = ze.getName();
                if (name.startsWith("WEB-INF/lib/")) {
                    GerritLauncher.extractJar(zf, ze, jars);
                    continue;
                }
                if (!name.startsWith("WEB-INF/pgm-lib/") || !prologCompiler && name.startsWith("WEB-INF/pgm-lib/prolog-")) continue;
                GerritLauncher.extractJar(zf, ze, jars);
            }
        }
        catch (IOException e) {
            throw new IOException("Cannot obtain libraries from " + path, e);
        }
        if (jars.isEmpty()) {
            return GerritLauncher.class.getClassLoader();
        }
        ArrayList<URL> extapi = new ArrayList<URL>();
        GerritLauncher.move(jars, "gerrit-extension-api-", extapi);
        GerritLauncher.move(jars, "guice-", extapi);
        GerritLauncher.move(jars, "javax.inject-1.jar", extapi);
        GerritLauncher.move(jars, "aopalliance-1.0.jar", extapi);
        GerritLauncher.move(jars, "guice-servlet-", extapi);
        GerritLauncher.move(jars, "servlet-api-", extapi);
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        if (!extapi.isEmpty()) {
            parent = URLClassLoader.newInstance(extapi.toArray(new URL[extapi.size()]), parent);
        }
        return new GerritClassLoader(jars.values().toArray(new URL[jars.size()]), parent);
    }

    private static void extractJar(ZipFile zf, ZipEntry ze, NavigableMap<String, URL> jars) throws IOException {
        File tmp = GerritLauncher.createTempFile(GerritLauncher.safeName(ze), ".jar");
        try (OutputStream out = Files.newOutputStream(tmp.toPath(), new OpenOption[0]);
             InputStream in = zf.getInputStream(ze);){
            int n;
            byte[] buf = new byte[4096];
            while ((n = in.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, n);
            }
        }
        String name = ze.getName();
        jars.put(name.substring(name.lastIndexOf(47)), tmp.toURI().toURL());
    }

    private static void move(NavigableMap<String, URL> jars, String prefix, List<URL> extapi) {
        String first;
        NavigableMap<String, URL> matches = jars.tailMap(prefix, true);
        if (!matches.isEmpty() && (first = (String)matches.firstKey()).startsWith(prefix)) {
            extapi.add((URL)jars.remove(first));
        }
    }

    private static String safeName(ZipEntry ze) {
        String name = ze.getName();
        if (name.contains("/")) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        if (name.contains(".")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (name.isEmpty()) {
            name = "code";
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getDistributionArchive() throws FileNotFoundException, IOException {
        File result = myArchive;
        if (result != null) return result;
        Class<GerritLauncher> clazz = GerritLauncher.class;
        synchronized (GerritLauncher.class) {
            result = myArchive;
            if (result != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
            myArchive = result = GerritLauncher.locateMyArchive();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static synchronized FileSystem getZipFileSystem(Path zip) throws IOException {
        FileSystem zipFs = zipFileSystems.get(zip = zip.toRealPath(new LinkOption[0]));
        if (zipFs == null) {
            zipFs = GerritLauncher.newZipFileSystem(zip);
            zipFileSystems.put(zip, zipFs);
        }
        return zipFs;
    }

    public static FileSystem newZipFileSystem(Path zip) throws IOException {
        return FileSystems.newFileSystem(URI.create("jar:" + zip.toUri()), Collections.emptyMap());
    }

    private static File locateMyArchive() throws FileNotFoundException {
        File path;
        String myName;
        ClassLoader myCL = GerritLauncher.class.getClassLoader();
        URL myClazz = myCL.getResource(myName = GerritLauncher.class.getName().replace('.', '/') + ".class");
        if (myClazz == null) {
            throw new FileNotFoundException("Cannot find JAR: no " + myName);
        }
        try {
            JarFile jar = ((JarURLConnection)myClazz.openConnection()).getJarFile();
            File path2 = new File(jar.getName());
            if (path2.isFile()) {
                return path2;
            }
        }
        catch (Exception jar) {
            // empty catch block
        }
        if ("file".equals(myClazz.getProtocol()) && (path = new File(myClazz.getPath())).isFile() && path.getParentFile().isDirectory()) {
            throw new FileNotFoundException(NOT_ARCHIVED);
        }
        CodeSource src = GerritLauncher.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            File file;
            block22: {
                InputStream in = src.getLocation().openStream();
                try {
                    File tmp = GerritLauncher.createTempFile("gerrit_", ".zip");
                    try (OutputStream out = Files.newOutputStream(tmp.toPath(), new OpenOption[0]);){
                        int n;
                        byte[] buf = new byte[4096];
                        while ((n = in.read(buf, 0, buf.length)) > 0) {
                            out.write(buf, 0, n);
                        }
                    }
                    file = tmp;
                    if (in == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                in.close();
            }
            return file;
        }
        throw new FileNotFoundException("Cannot find local copy of JAR");
    }

    public static synchronized File createTempFile(String prefix, String suffix) throws IOException {
        File tmp;
        if (!temporaryDirectoryFound) {
            File d = File.createTempFile("gerrit_", "_app", GerritLauncher.tmproot());
            if (d.delete() && d.mkdir()) {
                d.setWritable(false, false);
                d.setReadable(false, false);
                d.setExecutable(false, false);
                d.setWritable(true, true);
                d.setReadable(true, true);
                d.setExecutable(true, true);
                d.deleteOnExit();
                temporaryDirectory = d;
            }
            temporaryDirectoryFound = true;
        }
        if (temporaryDirectory != null && (tmp = new File(temporaryDirectory, (String)prefix + suffix)).createNewFile()) {
            tmp.deleteOnExit();
            return tmp;
        }
        if (!((String)prefix).endsWith("_")) {
            prefix = (String)prefix + "_";
        }
        tmp = File.createTempFile((String)prefix, suffix, temporaryDirectory);
        tmp.deleteOnExit();
        return tmp;
    }

    public static File getHomeDirectory() {
        if (myHome == null) {
            myHome = GerritLauncher.locateHomeDirectory();
        }
        return myHome;
    }

    private static File tmproot() {
        String gerritTemp = System.getenv("GERRIT_TMP");
        File tmp = gerritTemp != null && gerritTemp.length() > 0 ? new File(gerritTemp) : new File(GerritLauncher.getHomeDirectory(), "tmp");
        if (!tmp.exists() && !tmp.mkdirs()) {
            System.err.println("warning: cannot create " + tmp.getAbsolutePath());
            System.err.println("warning: using system temporary directory instead");
            return null;
        }
        File[] tmpEntries = tmp.listFiles();
        if (tmpEntries != null) {
            long now = System.currentTimeMillis();
            long expired = now - TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS);
            for (File tmpEntry : tmpEntries) {
                String[] all;
                if (!tmpEntry.isDirectory() || tmpEntry.lastModified() >= expired || (all = tmpEntry.list()) != null && all.length != 0) continue;
                tmpEntry.delete();
            }
        }
        try {
            return tmp.getCanonicalFile();
        }
        catch (IOException e) {
            return tmp;
        }
    }

    private static File locateHomeDirectory() {
        File gerrithome;
        String userHome = System.getProperty("user.home");
        if ((userHome == null || "".equals(userHome)) && ((userHome = System.getenv("HOME")) == null || "".equals(userHome))) {
            System.err.println("warning: cannot determine home directory");
            System.err.println("warning: using system temporary directory instead");
            return null;
        }
        File home = new File(userHome);
        if (!home.exists()) {
            if (home.mkdirs()) {
                System.err.println("warning: created " + home.getAbsolutePath());
            } else {
                System.err.println("warning: " + home.getAbsolutePath() + " not found");
                System.err.println("warning: using system temporary directory instead");
                return null;
            }
        }
        if (!(gerrithome = new File(home, ".gerritcodereview")).exists() && !gerrithome.mkdirs()) {
            System.err.println("warning: cannot create " + gerrithome.getAbsolutePath());
            System.err.println("warning: using system temporary directory instead");
            return null;
        }
        try {
            return gerrithome.getCanonicalFile();
        }
        catch (IOException e) {
            return gerrithome;
        }
    }

    public static boolean isRunningInEclipse() {
        return Thread.getAllStackTraces().values().stream().flatMap(Arrays::stream).anyMatch(e -> e.getClassName().startsWith("org.eclipse.jdt."));
    }

    public static Path getDeveloperEclipseOut() throws FileNotFoundException {
        return GerritLauncher.resolveInSourceRoot("eclipse-out");
    }

    public static boolean isJdk9OrLater() {
        return Double.parseDouble(System.getProperty("java.class.version")) >= 53.0;
    }

    public static String getJdkVersionPostJdk8() {
        return System.getProperty("java.version").substring(0, 1);
    }

    public static Properties loadBuildProperties(Path propPath) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = Files.newInputStream(propPath, new OpenOption[0]);){
            properties.load(in);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        return properties;
    }

    public static Path resolveInSourceRoot(String name) throws FileNotFoundException {
        Path ret;
        Path dir;
        Class<GerritLauncher> self = GerritLauncher.class;
        String sourceRoot = System.getProperty("sourceRoot");
        if (sourceRoot != null) {
            dir = Paths.get(sourceRoot, new String[0]);
            if (!Files.exists(dir, new LinkOption[0])) {
                throw new FileNotFoundException("source root not found: " + dir);
            }
        } else {
            URL u = self.getResource(self.getSimpleName() + ".class");
            if (u == null) {
                throw new FileNotFoundException("Cannot find class " + self.getName());
            }
            if ("jar".equals(u.getProtocol())) {
                String p = u.getPath();
                try {
                    u = new URL(p.substring(0, p.indexOf(33)));
                }
                catch (MalformedURLException e) {
                    FileNotFoundException fnfe = new FileNotFoundException("Not a valid jar file: " + u);
                    fnfe.initCause(e);
                    throw fnfe;
                }
            }
            if (!"file".equals(u.getProtocol())) {
                throw new FileNotFoundException("Cannot extract path from " + u);
            }
            dir = Paths.get(u.getPath(), new String[0]);
            while (!Files.isRegularFile(dir.resolve("WORKSPACE"), new LinkOption[0])) {
                Path parent = dir.getParent();
                if (parent == null) {
                    throw new FileNotFoundException("Cannot find source root from " + u);
                }
                dir = parent;
            }
        }
        if (!Files.exists(ret = dir.resolve(name), new LinkOption[0])) {
            throw new FileNotFoundException(name + " not found in source root " + dir);
        }
        return ret;
    }

    private static ClassLoader useDevClasspath() throws IOException {
        Path out = GerritLauncher.getDeveloperEclipseOut();
        ArrayList<URL> dirs = new ArrayList<URL>();
        dirs.add(out.resolve("classes").toUri().toURL());
        ClassLoader cl = GerritLauncher.class.getClassLoader();
        if (GerritLauncher.isJdk9OrLater()) {
            Path rootPath = GerritLauncher.resolveInSourceRoot(".").normalize();
            Properties properties = GerritLauncher.loadBuildProperties(rootPath.resolve(".bazel_path"));
            Path outputBase = Paths.get(properties.getProperty("output_base"), new String[0]);
            Path runtimeClasspath = rootPath.resolve("bazel-bin/tools/eclipse/main_classpath_collect.runtime_classpath");
            for (String f : Files.readAllLines(runtimeClasspath, StandardCharsets.UTF_8)) {
                URL url = f.startsWith("external") ? outputBase.resolve(f).toUri().toURL() : rootPath.resolve(f).toUri().toURL();
                if (!GerritLauncher.includeJar(url)) continue;
                dirs.add(url);
            }
        } else {
            for (URL u : ((URLClassLoader)cl).getURLs()) {
                if (!GerritLauncher.includeJar(u)) continue;
                dirs.add(u);
            }
        }
        return URLClassLoader.newInstance(dirs.toArray(new URL[dirs.size()]), ClassLoader.getSystemClassLoader().getParent());
    }

    private static boolean includeJar(URL u) {
        String path = u.getPath();
        return path.endsWith(".jar") && !path.endsWith("-src.jar") && !path.contains("/com/google/gerrit");
    }

    private GerritLauncher() {
    }

    static {
        zipFileSystems = new HashMap<Path, FileSystem>();
    }

    public static class GerritClassLoader
    extends URLClassLoader {
        GerritClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

