/*
 * Decompiled with CFR 0.152.
 */
package com.google.identitytoolkit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.identitytoolkit.DownloadIterator;
import com.google.identitytoolkit.GitkitClientException;
import com.google.identitytoolkit.GitkitServerException;
import com.google.identitytoolkit.GitkitUser;
import com.google.identitytoolkit.HttpSender;
import com.google.identitytoolkit.JsonTokenHelper;
import com.google.identitytoolkit.RpcHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitkitClient {
    @VisibleForTesting
    static final String GITKIT_API_BASE = "https://www.googleapis.com/identitytoolkit/v3/relyingparty/";
    private static final Logger logger = Logger.getLogger(GitkitClient.class.getName());
    private final JsonTokenHelper tokenHelper;
    private final RpcHelper rpcHelper;
    private final String widgetUrl;
    private final String cookieName;

    public GitkitClient(String clientId, String serviceAccountEmail, InputStream keyStream, String widgetUrl, String cookieName, HttpSender httpSender, String serverApiKey) {
        this.rpcHelper = new RpcHelper(httpSender, GITKIT_API_BASE, serviceAccountEmail, keyStream);
        this.tokenHelper = new JsonTokenHelper(clientId, this.rpcHelper, serverApiKey);
        this.widgetUrl = widgetUrl;
        this.cookieName = cookieName;
    }

    public static GitkitClient createFromJson(String configPath) throws JSONException, IOException {
        JSONObject configData = new JSONObject(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(Files.readAllBytes(Paths.get(configPath, new String[0])))).toString());
        return new Builder().setGoogleClientId(configData.getString("clientId")).setServiceAccountEmail(configData.getString("serviceAccountEmail")).setKeyStream(new FileInputStream(configData.getString("serviceAccountPrivateKeyFile"))).setWidgetUrl(configData.getString("widgetUrl")).setCookieName(configData.getString("cookieName")).setServerApiKey(configData.optString("serverApiKey", null)).build();
    }

    public GitkitUser validateToken(String token) throws GitkitClientException {
        if (token == null) {
            return null;
        }
        try {
            JsonObject jsonToken = this.tokenHelper.verifyAndDeserialize(token).getPayloadAsJsonObject();
            return new GitkitUser().setLocalId(jsonToken.get("user_id").getAsString()).setEmail(jsonToken.get("email").getAsString()).setCurrentProvider(jsonToken.has("provider_id") ? jsonToken.get("provider_id").getAsString() : null);
        }
        catch (SignatureException e) {
            throw new GitkitClientException(e);
        }
    }

    public GitkitUser validateTokenInRequest(HttpServletRequest request) throws GitkitClientException {
        Cookie[] cookies = request.getCookies();
        if (this.cookieName == null || cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!this.cookieName.equals(cookie.getName())) continue;
            return this.validateToken(cookie.getValue());
        }
        return null;
    }

    public GitkitUser getUserByToken(String token) throws GitkitClientException, GitkitServerException {
        GitkitUser gitkitUser = this.validateToken(token);
        if (gitkitUser == null) {
            throw new GitkitClientException("invalid gitkit token");
        }
        try {
            JSONObject result = this.rpcHelper.getAccountInfo(token);
            JSONObject jsonUser = result.getJSONArray("users").getJSONObject(0);
            return this.jsonToUser(jsonUser).setCurrentProvider(gitkitUser.getCurrentProvider());
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public GitkitUser getUserByEmail(String email) throws GitkitClientException, GitkitServerException {
        Preconditions.checkNotNull((Object)email);
        try {
            JSONObject result = this.rpcHelper.getAccountInfoByEmail(email);
            return this.jsonToUser(result.getJSONArray("users").getJSONObject(0));
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public GitkitUser getUserByLocalId(String localId) throws GitkitClientException, GitkitServerException {
        Preconditions.checkNotNull((Object)localId);
        try {
            JSONObject result = this.rpcHelper.getAccountInfoById(localId);
            return this.jsonToUser(result.getJSONArray("users").getJSONObject(0));
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public Iterator<GitkitUser> getAllUsers() {
        return this.getAllUsers(null);
    }

    public Iterator<GitkitUser> getAllUsers(final Integer resultsPerRequest) {
        return new DownloadIterator<GitkitUser>(){
            private String nextPageToken = null;

            @Override
            protected Iterator<GitkitUser> getNextResults() {
                try {
                    JSONObject response = GitkitClient.this.rpcHelper.downloadAccount(this.nextPageToken, resultsPerRequest);
                    String string = this.nextPageToken = response.has("nextPageToken") ? response.getString("nextPageToken") : null;
                    if (response.has("users")) {
                        return GitkitClient.this.jsonToList(response.getJSONArray("users")).iterator();
                    }
                }
                catch (JSONException e) {
                    logger.warning(e.getMessage());
                }
                catch (GitkitServerException e) {
                    logger.warning(e.getMessage());
                }
                catch (GitkitClientException e) {
                    logger.warning(e.getMessage());
                }
                return ImmutableSet.of().iterator();
            }
        };
    }

    public GitkitUser updateUser(GitkitUser user) throws GitkitClientException, GitkitServerException {
        try {
            return this.jsonToUser(this.rpcHelper.updateAccount(user));
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public void uploadUsers(String hashAlgorithm, byte[] hashKey, List<GitkitUser> users) throws GitkitServerException, GitkitClientException {
        this.rpcHelper.uploadAccount(hashAlgorithm, hashKey, users);
    }

    public void deleteUser(GitkitUser user) throws GitkitServerException, GitkitClientException {
        this.deleteUser(user.getLocalId());
    }

    public void deleteUser(String localId) throws GitkitServerException, GitkitClientException {
        this.rpcHelper.deleteAccount(localId);
    }

    public OobResponse getOobResponse(HttpServletRequest req) throws GitkitServerException {
        String gitkitToken = this.lookupCookie(req, this.cookieName);
        return this.getOobResponse(req, gitkitToken);
    }

    public OobResponse getOobResponse(HttpServletRequest req, String gitkitToken) throws GitkitServerException {
        try {
            String action = req.getParameter("action");
            if ("resetPassword".equals(action)) {
                String oobLink = this.buildOobLink(req, this.buildPasswordResetRequest(req), action);
                return new OobResponse(this, req.getParameter("email"), null, oobLink, OobAction.RESET_PASSWORD);
            }
            if ("changeEmail".equals(action)) {
                if (gitkitToken == null) {
                    return new OobResponse(this, "login is required");
                }
                String oobLink = this.buildOobLink(req, this.buildChangeEmailRequest(req, gitkitToken), action);
                return new OobResponse(this, req.getParameter("oldEmail"), req.getParameter("newEmail"), oobLink, OobAction.CHANGE_EMAIL);
            }
            return new OobResponse(this, "unknown request");
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
        catch (GitkitClientException e) {
            return new OobResponse(this, e.getMessage());
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private String lookupCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    private String buildOobLink(HttpServletRequest req, JSONObject resetReq, String modeParam) throws GitkitClientException, GitkitServerException, JSONException {
        try {
            JSONObject result = this.rpcHelper.getOobCode(resetReq);
            String code = result.getString("oobCode");
            String string = String.valueOf(String.valueOf(this.widgetUrl));
            String string2 = String.valueOf(String.valueOf(modeParam));
            String string3 = String.valueOf(String.valueOf(URLEncoder.encode(code, "UTF-8")));
            return new StringBuilder(15 + string.length() + string2.length() + string3.length()).append(string).append("?mode=").append(string2).append("&oobCode=").append(string3).toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new GitkitServerException(e);
        }
    }

    private JSONObject buildPasswordResetRequest(HttpServletRequest req) throws JSONException {
        return new JSONObject().put("email", (Object)req.getParameter("email")).put("userIp", (Object)req.getRemoteAddr()).put("challenge", (Object)req.getParameter("challenge")).put("captchaResp", (Object)req.getParameter("response")).put("requestType", (Object)"PASSWORD_RESET");
    }

    private JSONObject buildChangeEmailRequest(HttpServletRequest req, String gitkitToken) throws JSONException {
        return new JSONObject().put("email", (Object)req.getParameter("oldEmail")).put("userIp", (Object)req.getRemoteAddr()).put("newEmail", (Object)req.getParameter("newEmail")).put("idToken", (Object)gitkitToken).put("requestType", (Object)"NEW_EMAIL_ACCEPT");
    }

    private List<GitkitUser> jsonToList(JSONArray accounts) throws JSONException {
        LinkedList list = Lists.newLinkedList();
        for (int i = 0; i < accounts.length(); ++i) {
            list.add(this.jsonToUser(accounts.getJSONObject(i)));
        }
        return list;
    }

    private GitkitUser jsonToUser(JSONObject jsonUser) throws JSONException {
        GitkitUser user = new GitkitUser().setLocalId(jsonUser.getString("localId")).setEmail(jsonUser.getString("email")).setName(jsonUser.optString("displayName")).setPhotoUrl(jsonUser.optString("photoUrl")).setProviders(jsonUser.optJSONArray("providerUserInfo"));
        if (jsonUser.has("providerUserInfo")) {
            JSONArray fedInfo = jsonUser.getJSONArray("providerUserInfo");
            ArrayList<GitkitUser.ProviderInfo> providerInfo = new ArrayList<GitkitUser.ProviderInfo>();
            for (int idp = 0; idp < fedInfo.length(); ++idp) {
                JSONObject provider = fedInfo.getJSONObject(idp);
                providerInfo.add(new GitkitUser.ProviderInfo(provider.getString("providerId"), provider.getString("federatedId"), provider.optString("displayName"), provider.optString("photoUrl")));
            }
            user.setProviders(providerInfo);
        }
        return user;
    }

    public static class Builder {
        private String clientId;
        private HttpSender httpSender = new HttpSender();
        private String widgetUrl;
        private String serviceAccountEmail;
        private InputStream keyStream;
        private String serverApiKey;
        private String cookieName = "gtoken";

        public Builder setGoogleClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setWidgetUrl(String url) {
            this.widgetUrl = url;
            return this;
        }

        public Builder setKeyStream(InputStream keyStream) {
            this.keyStream = keyStream;
            return this;
        }

        public Builder setServiceAccountEmail(String serviceAccountEmail) {
            this.serviceAccountEmail = serviceAccountEmail;
            return this;
        }

        public Builder setCookieName(String cookieName) {
            this.cookieName = cookieName;
            return this;
        }

        public Builder setHttpSender(HttpSender httpSender) {
            this.httpSender = httpSender;
            return this;
        }

        public Builder setServerApiKey(String serverApiKey) {
            this.serverApiKey = serverApiKey;
            return this;
        }

        public GitkitClient build() {
            return new GitkitClient(this.clientId, this.serviceAccountEmail, this.keyStream, this.widgetUrl, this.cookieName, this.httpSender, this.serverApiKey);
        }
    }

    public class OobResponse {
        private static final String SUCCESS_RESPONSE = "{\"success\": true}";
        private static final String ERROR_PREFIX = "{\"error\": ";
        private final String email;
        private final String newEmail;
        private final Optional<String> oobUrl;
        private final OobAction oobAction;
        private final String responseBody;
        private final String recipient;
        final /* synthetic */ GitkitClient this$0;

        public OobResponse(GitkitClient gitkitClient, String responseBody) {
            String string = String.valueOf(String.valueOf(ERROR_PREFIX));
            String string2 = String.valueOf(String.valueOf(responseBody));
            this(gitkitClient, null, null, (Optional<String>)Optional.absent(), null, new StringBuilder(2 + string.length() + string2.length()).append(string).append(string2).append(" }").toString());
        }

        public OobResponse(GitkitClient gitkitClient, String email, String newEmail, String oobUrl, OobAction oobAction) {
            this(gitkitClient, email, newEmail, (Optional<String>)Optional.of((Object)oobUrl), oobAction, SUCCESS_RESPONSE);
        }

        public OobResponse(GitkitClient gitkitClient, String email, String newEmail, Optional<String> oobUrl, OobAction oobAction, String responseBody) {
            this.this$0 = gitkitClient;
            this.email = email;
            this.newEmail = newEmail;
            this.oobUrl = oobUrl;
            this.oobAction = oobAction;
            this.responseBody = responseBody;
            this.recipient = newEmail == null ? email : newEmail;
        }

        public Optional<String> getOobUrl() {
            return this.oobUrl;
        }

        public OobAction getOobAction() {
            return this.oobAction;
        }

        public String getResponseBody() {
            return this.responseBody;
        }

        public String getEmail() {
            return this.email;
        }

        public String getNewEmail() {
            return this.newEmail;
        }

        public String getRecipient() {
            return this.recipient;
        }
    }

    public static enum OobAction {
        RESET_PASSWORD,
        CHANGE_EMAIL;

    }
}

