/*
 * Decompiled with CFR 0.152.
 */
package com.google.identitytoolkit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import net.oauth.jsontoken.crypto.RsaSHA256Verifier;
import net.oauth.jsontoken.crypto.Verifier;

public class GitkitTokenVerifier
implements Verifier {
    @VisibleForTesting
    final RsaSHA256Verifier verifier;

    public GitkitTokenVerifier(String cert) {
        X509Certificate x509Cert;
        CertificateFactory factory;
        String pem = cert.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", "").replaceAll("\n", "");
        byte[] der = BaseEncoding.base64().decode((CharSequence)pem);
        try {
            factory = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("No X509 instance.", e);
        }
        try {
            x509Cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(der));
        }
        catch (CertificateException e) {
            throw new RuntimeException("Certificate exception.", e);
        }
        this.verifier = new RsaSHA256Verifier(x509Cert.getPublicKey());
    }

    public void verifySignature(byte[] source, byte[] signature) throws SignatureException {
        this.verifier.verifySignature(source, signature);
    }
}

