/*
 * Decompiled with CFR 0.152.
 */
package com.google.identitytoolkit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.identitytoolkit.GitkitServerException;
import com.google.identitytoolkit.GitkitTokenVerifier;
import com.google.identitytoolkit.RpcHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import net.oauth.jsontoken.crypto.Verifier;
import net.oauth.jsontoken.discovery.VerifierProvider;

public class GitkitVerifierManager
implements VerifierProvider {
    private final Lock lock = new ReentrantLock();
    private static final Logger log = Logger.getLogger(GitkitVerifierManager.class.getName());
    private final RpcHelper rpcHelper;
    private final String serverApiKey;
    private Map<String, GitkitTokenVerifier> verifiers = Maps.newHashMap();

    public GitkitVerifierManager(RpcHelper rpcHelper) {
        this(rpcHelper, null);
    }

    public GitkitVerifierManager(RpcHelper rpcHelper, String serverApiKey) {
        this.rpcHelper = rpcHelper;
        this.serverApiKey = serverApiKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Verifier> findVerifier(String issuer, String keyId) {
        this.lock.lock();
        try {
            if (!this.verifiers.containsKey(keyId)) {
                this.initVerifiers();
            }
            ArrayList arrayList = Lists.newArrayList((Object[])new Verifier[]{this.verifiers.get(keyId)});
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initVerifiers() {
        try {
            Map<String, String> certs = this.parseCertsResponse(this.rpcHelper.downloadCerts(this.serverApiKey));
            this.verifiers.clear();
            for (String kid : certs.keySet()) {
                this.verifiers.put(kid, new GitkitTokenVerifier(certs.get(kid)));
            }
        }
        catch (IOException e) {
            String string = String.valueOf(e.getMessage());
            log.warning(string.length() != 0 ? "unable to find token verifier: ".concat(string) : new String("unable to find token verifier: "));
        }
        catch (GitkitServerException e) {
            String string = String.valueOf(e.getMessage());
            log.warning(string.length() != 0 ? "unable to find token verifier: ".concat(string) : new String("unable to find token verifier: "));
        }
    }

    @VisibleForTesting
    Map<String, String> parseCertsResponse(String response) throws GitkitServerException {
        try {
            JsonObject jsonCerts = new JsonParser().parse(response).getAsJsonObject();
            HashMap certs = Maps.newHashMap();
            for (Map.Entry entry : jsonCerts.entrySet()) {
                certs.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            return certs;
        }
        catch (JsonSyntaxException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }
}

