/*
 * Decompiled with CFR 0.152.
 */
package com.google.identitytoolkit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class HttpSender {
    private static final String USER_AGENT = "GitkitJavaClient/1.0";

    public String get(String url, Map<String, String> headers) throws IOException {
        return this.doHttpTransfer(url, null, headers);
    }

    public String post(String url, String data, Map<String, String> headers) throws IOException {
        return this.doHttpTransfer(url, data, headers);
    }

    private String doHttpTransfer(String url, String data, Map<String, String> headers) throws IOException {
        try {
            String line;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setDoOutput(true);
            if (data != null) {
                connection.setRequestMethod("POST");
                OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
                writer.write(data);
                writer.close();
            } else {
                connection.setRequestMethod("GET");
            }
            InputStream inputStream = connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            return response.toString();
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
    }
}

