/*
 * Decompiled with CFR 0.152.
 */
package com.google.identitytoolkit;

import com.google.gson.JsonObject;
import com.google.identitytoolkit.GitkitVerifierManager;
import com.google.identitytoolkit.RpcHelper;
import java.security.SignatureException;
import net.oauth.jsontoken.Checker;
import net.oauth.jsontoken.JsonToken;
import net.oauth.jsontoken.JsonTokenParser;
import net.oauth.jsontoken.crypto.SignatureAlgorithm;
import net.oauth.jsontoken.discovery.VerifierProvider;
import net.oauth.jsontoken.discovery.VerifierProviders;

public class JsonTokenHelper {
    public static final String ID_TOKEN_EMAIL = "email";
    public static final String ID_TOKEN_USER_ID = "user_id";
    public static final String ID_TOKEN_PROVIDER = "provider_id";
    private final JsonTokenParser parser;

    public JsonTokenHelper(String audience, RpcHelper rpcHelper, String serverApiKey) {
        VerifierProviders verifierProviders = new VerifierProviders();
        verifierProviders.setVerifierProvider(SignatureAlgorithm.RS256, (VerifierProvider)new GitkitVerifierManager(rpcHelper, serverApiKey));
        this.parser = new JsonTokenParser(verifierProviders, (Checker)new AudienceChecker(audience));
    }

    public JsonToken verifyAndDeserialize(String token) throws SignatureException {
        return this.parser.verifyAndDeserialize(token);
    }

    public static class AudienceChecker
    implements Checker {
        private final String expectedAudience;

        public AudienceChecker(String audience) {
            this.expectedAudience = audience;
        }

        public void check(JsonObject payload) throws SignatureException {
            if (!payload.has("aud")) {
                throw new SignatureException("No audience in payload.");
            }
            String audience = payload.get("aud").getAsString();
            if (!this.expectedAudience.equals(audience)) {
                throw new SignatureException(String.format("Invalid audience: %s. Should be: %s", audience, this.expectedAudience));
            }
        }
    }
}

