/*
 * Decompiled with CFR 0.152.
 */
package com.google.identitytoolkit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.google.identitytoolkit.GitkitClientException;
import com.google.identitytoolkit.GitkitServerException;
import com.google.identitytoolkit.GitkitUser;
import com.google.identitytoolkit.HttpSender;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import net.oauth.jsontoken.JsonToken;
import net.oauth.jsontoken.crypto.RsaSHA256Signer;
import net.oauth.jsontoken.crypto.Signer;
import org.joda.time.Instant;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RpcHelper {
    @VisibleForTesting
    static final String GITKIT_SCOPE = "https://www.googleapis.com/auth/identitytoolkit";
    @VisibleForTesting
    static final String TOKEN_SERVER = "https://accounts.google.com/o/oauth2/token";
    private static final Logger log = Logger.getLogger(RpcHelper.class.getName());
    private final RsaSHA256Signer signer;
    private final String gitkitApiUrl;
    private final HttpSender httpSender;

    public RpcHelper(HttpSender httpSender, String gitkitApiUrl, String serviceAccountEmail, InputStream keyStream) {
        this.gitkitApiUrl = gitkitApiUrl;
        this.httpSender = httpSender;
        this.signer = this.initRsaSHA256Signer(serviceAccountEmail, keyStream);
    }

    public JSONObject createAuthUri(String identifier, String continueUri, String context) throws GitkitServerException, GitkitClientException {
        JSONObject params = new JSONObject();
        try {
            if (identifier != null) {
                params.put("identifier", (Object)identifier);
            }
            if (continueUri != null) {
                params.put("continueUri", (Object)continueUri);
            }
            if (context != null) {
                params.put("context", (Object)context);
            }
            return this.invokeGitkitApi("createAuthUri", params, null);
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public JSONObject verifyAssertion(String requestUri, String postBody) throws GitkitServerException, GitkitClientException {
        JSONObject params = new JSONObject();
        try {
            params.put("requestUri", (Object)requestUri);
            if (postBody != null) {
                params.put("postBody", (Object)postBody);
            }
            return this.invokeGitkitApi("verifyAssertion", params, null);
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public JSONObject getOobCode(JSONObject resetReq) throws GitkitClientException, GitkitServerException {
        return this.invokeGoogle2LegOauthApi("getOobConfirmationCode", resetReq);
    }

    public JSONObject getAccountInfo(String idToken) throws GitkitClientException, GitkitServerException {
        try {
            JSONObject params = new JSONObject().put("idToken", (Object)idToken);
            return this.invokeGoogle2LegOauthApi("getAccountInfo", params);
        }
        catch (JSONException e) {
            throw new GitkitServerException("OAuth API failed");
        }
    }

    public JSONObject getAccountInfoById(String localId) throws GitkitClientException, GitkitServerException {
        try {
            JSONObject params = new JSONObject().put("localId", (Object)new JSONArray().put((Object)localId));
            return this.invokeGoogle2LegOauthApi("getAccountInfo", params);
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public JSONObject getAccountInfoByEmail(String email) throws GitkitClientException, GitkitServerException {
        try {
            JSONObject params = new JSONObject().put("email", (Object)new JSONArray().put((Object)email));
            return this.invokeGoogle2LegOauthApi("getAccountInfo", params);
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public JSONObject updateAccount(GitkitUser account) throws GitkitServerException, GitkitClientException {
        try {
            JSONObject params = new JSONObject().put("email", (Object)account.getEmail()).put("localId", (Object)account.getLocalId());
            if (account.getName() != null) {
                params.put("displayName", (Object)account.getName());
            }
            if (account.getHash() != null) {
                params.put("password", (Object)account.getHash());
            }
            return this.invokeGoogle2LegOauthApi("setAccountInfo", params);
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public JSONObject downloadAccount(String nextPageToken, Integer maxResults) throws GitkitClientException, GitkitServerException {
        try {
            JSONObject params = new JSONObject();
            if (nextPageToken != null) {
                params.put("nextPageToken", (Object)nextPageToken);
            }
            if (maxResults != null) {
                params.put("maxResults", (Object)maxResults);
            }
            return this.invokeGoogle2LegOauthApi("downloadAccount", params);
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public JSONObject uploadAccount(String hashAlgorithm, byte[] hashKey, List<GitkitUser> accounts) throws GitkitClientException, GitkitServerException {
        try {
            JSONObject params = new JSONObject().put("hashAlgorithm", (Object)hashAlgorithm).put("signerKey", (Object)BaseEncoding.base64Url().encode(hashKey)).put("users", (Object)RpcHelper.toJsonArray(accounts));
            return this.invokeGoogle2LegOauthApi("uploadAccount", params);
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    public JSONObject deleteAccount(String localId) throws GitkitClientException, GitkitServerException {
        try {
            JSONObject params = new JSONObject().put("localId", (Object)localId);
            return this.invokeGoogle2LegOauthApi("deleteAccount", params);
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
    }

    String downloadCerts(String serverApiKey) throws IOException {
        String certUrl = String.valueOf(this.gitkitApiUrl).concat("publicKeys");
        HashMap headers = Maps.newHashMap();
        if (serverApiKey != null) {
            String string = String.valueOf(certUrl);
            String string2 = String.valueOf(String.valueOf(serverApiKey));
            certUrl = new StringBuilder(5 + string.length() + string2.length()).append(string).append("?key=").append(string2).toString();
        } else {
            try {
                String string = String.valueOf(this.getAccessToken());
                headers.put("Authorization", string.length() != 0 ? "Bearer ".concat(string) : new String("Bearer "));
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
        return this.httpSender.get(certUrl, headers);
    }

    @VisibleForTesting
    JSONObject invokeGoogle2LegOauthApi(String method, JSONObject req) throws GitkitClientException, GitkitServerException {
        try {
            String accessToken = this.getAccessToken();
            return this.invokeGitkitApi(method, req, accessToken);
        }
        catch (GeneralSecurityException e) {
            throw new GitkitServerException(e);
        }
        catch (JSONException e) {
            throw new GitkitServerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new GitkitServerException(e);
        }
    }

    @VisibleForTesting
    String getAccessToken() throws GeneralSecurityException, IOException, JSONException {
        String assertion = this.signServiceAccountRequest();
        String string = String.valueOf(assertion);
        String data = string.length() != 0 ? "grant_type=urn%3Aietf%3Aparams%3Aoauth%3Agrant-type%3Ajwt-bearer&assertion=".concat(string) : new String("grant_type=urn%3Aietf%3Aparams%3Aoauth%3Agrant-type%3Ajwt-bearer&assertion=");
        HashMap headers = Maps.newHashMap();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        String response = this.httpSender.post(TOKEN_SERVER, data, headers);
        return new JSONObject(response).getString("access_token");
    }

    @VisibleForTesting
    String signServiceAccountRequest() throws GeneralSecurityException {
        JsonToken assertion = new JsonToken((Signer)this.signer);
        assertion.setAudience(TOKEN_SERVER);
        assertion.setParam("nonce", "nonce");
        assertion.setParam("scope", GITKIT_SCOPE);
        assertion.setIssuedAt(new Instant());
        assertion.setExpiration(new Instant().plus(3600000L));
        return assertion.serializeAndSign();
    }

    private JSONObject invokeGitkitApi(String method, JSONObject params, String accessToken) throws GitkitClientException, GitkitServerException {
        try {
            HashMap headers = Maps.newHashMap();
            if (accessToken != null) {
                String string = String.valueOf(accessToken);
                headers.put("Authorization", string.length() != 0 ? "Bearer ".concat(string) : new String("Bearer "));
            }
            headers.put("Content-Type", "application/json");
            String string = String.valueOf(this.gitkitApiUrl);
            String string2 = String.valueOf(method);
            String response = this.httpSender.post(string2.length() != 0 ? string.concat(string2) : new String(string), params.toString(), headers);
            return this.checkGitkitException(response);
        }
        catch (IOException e) {
            throw new GitkitServerException(e);
        }
    }

    private RsaSHA256Signer initRsaSHA256Signer(String serviceAccountEmail, InputStream keyStream) {
        String string;
        try {
            if (serviceAccountEmail != null && keyStream != null) {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(keyStream, "notasecret".toCharArray());
                return new RsaSHA256Signer(serviceAccountEmail, null, (RSAPrivateKey)keyStore.getKey("privatekey", "notasecret".toCharArray()));
            }
        }
        catch (KeyStoreException e) {
            string = String.valueOf(String.valueOf(e));
            log.warning(new StringBuilder(43 + string.length()).append("can not initialize service account signer: ").append(string).toString());
        }
        catch (CertificateException e) {
            string = String.valueOf(String.valueOf(e));
            log.warning(new StringBuilder(43 + string.length()).append("can not initialize service account signer: ").append(string).toString());
        }
        catch (UnrecoverableKeyException e) {
            string = String.valueOf(String.valueOf(e));
            log.warning(new StringBuilder(43 + string.length()).append("can not initialize service account signer: ").append(string).toString());
        }
        catch (NoSuchAlgorithmException e) {
            string = String.valueOf(String.valueOf(e));
            log.warning(new StringBuilder(43 + string.length()).append("can not initialize service account signer: ").append(string).toString());
        }
        catch (IOException e) {
            string = String.valueOf(String.valueOf(e));
            log.warning(new StringBuilder(43 + string.length()).append("can not initialize service account signer: ").append(string).toString());
        }
        catch (InvalidKeyException e) {
            string = String.valueOf(String.valueOf(e));
            log.warning(new StringBuilder(43 + string.length()).append("can not initialize service account signer: ").append(string).toString());
        }
        String string2 = String.valueOf(String.valueOf(serviceAccountEmail));
        string = String.valueOf(String.valueOf(keyStream));
        log.warning(new StringBuilder(59 + string2.length() + string.length()).append("service account is set to null due to: email = ").append(string2).append("keystream = ").append(string).toString());
        return null;
    }

    private static JSONArray toJsonArray(List<GitkitUser> accounts) throws JSONException {
        JSONArray infos = new JSONArray();
        for (GitkitUser account : accounts) {
            JSONObject user = new JSONObject();
            user.put("email", (Object)account.getEmail());
            user.put("localId", (Object)account.getLocalId());
            if (account.getHash() != null) {
                user.put("passwordHash", (Object)BaseEncoding.base64Url().encode(account.getHash()));
            }
            if (account.getSalt() != null) {
                user.put("salt", (Object)BaseEncoding.base64Url().encode(account.getSalt()));
            }
            if (account.getProviders() != null) {
                JSONArray providers = new JSONArray();
                for (GitkitUser.ProviderInfo idpInfo : account.getProviders()) {
                    providers.put((Object)new JSONObject().put("federatedId", (Object)idpInfo.getFederatedId()).put("providerId", (Object)idpInfo.getProviderId()));
                }
                user.put("providerUserInfo", (Object)providers);
            }
            infos.put((Object)user);
        }
        return infos;
    }

    @VisibleForTesting
    JSONObject checkGitkitException(String response) throws GitkitClientException, GitkitServerException {
        try {
            JSONObject result = new JSONObject(response);
            if (!result.has("error")) {
                return result;
            }
            JSONObject error = result.getJSONObject("error");
            String code = error.optString("code");
            if (code != null) {
                if (code.startsWith("4")) {
                    throw new GitkitClientException(error.optString("message"));
                }
                throw new GitkitServerException(error.optString("message"));
            }
        }
        catch (JSONException e) {
            String string = String.valueOf(e.getMessage());
            log.warning(string.length() != 0 ? "Server response exception: ".concat(string) : new String("Server response exception: "));
        }
        throw new GitkitServerException("null error code from Gitkit server");
    }
}

