/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import java.io.IOException;
import junit.framework.TestCase;

public abstract class AuthenticationTestBase
extends TestCase {
    protected static final JsonFactory JSON_FACTORY = new JacksonFactory();
    protected static final String ACCESS_TOKEN = "abc";
    protected static final String NEW_ACCESS_TOKEN = "def";
    protected static final GenericUrl TOKEN_SERVER_URL = new GenericUrl("http://example.com/token");
    protected static final String CLIENT_ID = "id";
    protected static final String CLIENT_SECRET = "secret";
    protected static final String REFRESH_TOKEN = "refreshToken";
    protected static final String NEW_REFRESH_TOKEN = "newRefreshToken";
    protected static final long EXPIRES_IN = 3600L;

    public AuthenticationTestBase() {
    }

    public AuthenticationTestBase(String name) {
        super(name);
    }

    protected static class AccessTokenTransport
    extends MockHttpTransport {
        int statusCode = 200;
        String wwwAuthenticate = null;
        int calls = 0;

        protected AccessTokenTransport() {
        }

        public LowLevelHttpRequest buildRequest(String method, String url) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    TokenErrorResponse responseData;
                    ++AccessTokenTransport.this.calls;
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.setContentType("application/json; charset=UTF-8");
                    if (AccessTokenTransport.this.statusCode == 401 || AccessTokenTransport.this.wwwAuthenticate != null) {
                        if (AccessTokenTransport.this.wwwAuthenticate != null) {
                            response.addHeader("WWW-Authenticate", AccessTokenTransport.this.wwwAuthenticate);
                            AccessTokenTransport.this.wwwAuthenticate = null;
                        }
                        response.setStatusCode(AccessTokenTransport.this.statusCode);
                        AccessTokenTransport.this.statusCode = 200;
                        return response;
                    }
                    if (AccessTokenTransport.this.statusCode != 200) {
                        TokenErrorResponse json = new TokenErrorResponse();
                        json.setError("invalid_client");
                        responseData = json;
                        response.setStatusCode(AccessTokenTransport.this.statusCode);
                    } else {
                        TokenResponse json = new TokenResponse();
                        json.setAccessToken(AuthenticationTestBase.NEW_ACCESS_TOKEN);
                        json.setRefreshToken(AuthenticationTestBase.NEW_REFRESH_TOKEN);
                        json.setExpiresInSeconds(Long.valueOf(3600L));
                        responseData = json;
                    }
                    response.setContent(JSON_FACTORY.toString((Object)responseData));
                    return response;
                }
            };
        }
    }
}

