/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthenticationTestBase;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.Joiner;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class AuthorizationCodeFlowTest
extends AuthenticationTestBase {
    public void testCredentialCreatedListener() throws IOException {
        MyCredentialCreatedListener listener = new MyCredentialCreatedListener();
        AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(BearerToken.queryParameterAccessMethod(), (HttpTransport)new AuthenticationTestBase.AccessTokenTransport(), (JsonFactory)new JacksonFactory(), TOKEN_SERVER_URL, (HttpExecuteInterceptor)new BasicAuthentication("id", "secret"), "id", "authorizationServerEncodedUrl").setCredentialCreatedListener((AuthorizationCodeFlow.CredentialCreatedListener)listener).build();
        AuthorizationCodeFlowTest.assertFalse((boolean)listener.called);
        flow.createAndStoreCredential(new TokenResponse(), "userId");
        AuthorizationCodeFlowTest.assertTrue((boolean)listener.called);
    }

    public void testRefreshListeners() throws IOException {
        MyCredentialRefreshListener listener1 = new MyCredentialRefreshListener();
        MyCredentialRefreshListener listener2 = new MyCredentialRefreshListener();
        AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(BearerToken.queryParameterAccessMethod(), (HttpTransport)new AuthenticationTestBase.AccessTokenTransport(), (JsonFactory)new JacksonFactory(), TOKEN_SERVER_URL, (HttpExecuteInterceptor)new BasicAuthentication("id", "secret"), "id", "authorizationServerEncodedUrl").addRefreshListener((CredentialRefreshListener)listener1).addRefreshListener((CredentialRefreshListener)listener2).build();
        TokenResponse tokenResponse = new TokenResponse();
        tokenResponse.setAccessToken("abc");
        tokenResponse.setRefreshToken("refreshToken");
        Credential cred = flow.createAndStoreCredential(tokenResponse, "userId");
        AuthorizationCodeFlowTest.assertFalse((boolean)listener1.calledOnResponse);
        AuthorizationCodeFlowTest.assertFalse((boolean)listener2.calledOnResponse);
        AuthorizationCodeFlowTest.assertFalse((boolean)listener1.calledOnError);
        AuthorizationCodeFlowTest.assertFalse((boolean)listener2.calledOnError);
        AuthorizationCodeFlowTest.assertTrue((boolean)cred.refreshToken());
        AuthorizationCodeFlowTest.assertTrue((boolean)listener1.calledOnResponse);
        AuthorizationCodeFlowTest.assertTrue((boolean)listener2.calledOnResponse);
        AuthorizationCodeFlowTest.assertFalse((boolean)listener1.calledOnError);
        AuthorizationCodeFlowTest.assertFalse((boolean)listener2.calledOnError);
    }

    public void testNewAuthorizationUrl() {
        this.subsetTestNewAuthorizationUrl(Collections.emptyList());
        this.subsetTestNewAuthorizationUrl(Collections.singleton("a"));
        this.subsetTestNewAuthorizationUrl(Arrays.asList("a", "b", "c", "d"));
    }

    public void subsetTestNewAuthorizationUrl(Collection<String> scopes) {
        AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(BearerToken.queryParameterAccessMethod(), (HttpTransport)new AuthenticationTestBase.AccessTokenTransport(), (JsonFactory)new JacksonFactory(), TOKEN_SERVER_URL, (HttpExecuteInterceptor)new BasicAuthentication("id", "secret"), "id", "https://example.com").setScopes(scopes).build();
        AuthorizationCodeRequestUrl url = flow.newAuthorizationUrl();
        if (scopes.isEmpty()) {
            AuthorizationCodeFlowTest.assertNull((Object)url.getScopes());
        } else {
            AuthorizationCodeFlowTest.assertEquals((String)Joiner.on((char)' ').join(scopes), (String)url.getScopes());
        }
    }

    static class MyCredentialRefreshListener
    implements CredentialRefreshListener {
        boolean calledOnResponse = false;
        boolean calledOnError = false;

        MyCredentialRefreshListener() {
        }

        public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
            this.calledOnResponse = true;
        }

        public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
            this.calledOnError = true;
        }
    }

    static class MyCredentialCreatedListener
    implements AuthorizationCodeFlow.CredentialCreatedListener {
        boolean called = false;

        MyCredentialCreatedListener() {
        }

        public void onCredentialCreated(Credential credential, TokenResponse tokenResponse) throws IOException {
            this.called = true;
        }
    }
}

