/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.Key;
import junit.framework.TestCase;

public class CustomTokenResponseTest
extends TestCase {
    private static final String JSON = "{\"access_token\":\"2YotnFZFEjr1zCsicMWpAA\",\"token_type\":\"example\",\"expires_in\":\"3600\",\"refresh_token\":\"tGzv3JOkF0XG5Qx2TlKWIA\",\"example_parameter\":\"example_value\"}";

    public void testStringExpires() throws Exception {
        JacksonFactory jsonFactory = new JacksonFactory();
        TokenResponse response = (TokenResponse)jsonFactory.fromString(JSON, StringExpiresTokenResponse.class);
        CustomTokenResponseTest.assertEquals((String)"2YotnFZFEjr1zCsicMWpAA", (String)response.getAccessToken());
        CustomTokenResponseTest.assertEquals((String)"example", (String)response.getTokenType());
        CustomTokenResponseTest.assertEquals((long)3600L, (long)response.getExpiresInSeconds());
        CustomTokenResponseTest.assertEquals((String)"tGzv3JOkF0XG5Qx2TlKWIA", (String)response.getRefreshToken());
        CustomTokenResponseTest.assertEquals((Object)"example_value", (Object)response.get((Object)"example_parameter"));
    }

    public static class StringExpiresTokenResponse
    extends TokenResponse {
        @Key(value="expires_in")
        private String expiresInSecondsString;

        public Long getExpiresInSeconds() {
            return Long.parseLong(this.expiresInSecondsString);
        }

        public StringExpiresTokenResponse setExpiresInSeconds(Long expiresInSeconds) {
            this.expiresInSecondsString = expiresInSeconds.toString();
            return this;
        }
    }
}

