/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import junit.framework.TestCase;

public class TokenRequestTest
extends TestCase {
    static final MockHttpTransport TRANSPORT = new MockHttpTransport();
    static final JacksonFactory JSON_FACTORY = new JacksonFactory();
    static final GenericUrl AUTHORIZATION_SERVER_URL = new GenericUrl("https://server.example.com/authorize");

    public void testConstructor() {
        TokenRequest request = new TokenRequest((HttpTransport)TRANSPORT, (JsonFactory)JSON_FACTORY, AUTHORIZATION_SERVER_URL, "foo");
        TokenRequestTest.check(request, "foo");
        TokenRequestTest.assertEquals(TokenResponse.class, (Object)request.getResponseClass());
    }

    static void check(TokenRequest request, String grantType) {
        TokenRequestTest.assertEquals((String)grantType, (String)request.getGrantType());
        TokenRequestTest.assertNull((Object)request.getScopes());
        TokenRequestTest.assertEquals((Object)TRANSPORT, (Object)request.getTransport());
        TokenRequestTest.assertEquals((Object)JSON_FACTORY, (Object)request.getJsonFactory());
        TokenRequestTest.assertEquals((Object)AUTHORIZATION_SERVER_URL, (Object)request.getTokenServerUrl());
    }
}

