/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.json.jackson.JacksonFactory;
import junit.framework.TestCase;

public class TokenResponseTest
extends TestCase {
    private static final String JSON = "{\"access_token\":\"2YotnFZFEjr1zCsicMWpAA\",\"token_type\":\"example\",\"expires_in\":3600,\"refresh_token\":\"tGzv3JOkF0XG5Qx2TlKWIA\",\"example_parameter\":\"example_value\"}";

    public void test() throws Exception {
        JacksonFactory jsonFactory = new JacksonFactory();
        TokenResponse response = (TokenResponse)jsonFactory.fromString(JSON, TokenResponse.class);
        TokenResponseTest.assertEquals((String)"2YotnFZFEjr1zCsicMWpAA", (String)response.getAccessToken());
        TokenResponseTest.assertEquals((String)"example", (String)response.getTokenType());
        TokenResponseTest.assertEquals((long)3600L, (long)response.getExpiresInSeconds());
        TokenResponseTest.assertEquals((String)"tGzv3JOkF0XG5Qx2TlKWIA", (String)response.getRefreshToken());
        TokenResponseTest.assertEquals((Object)"example_value", (Object)response.get((Object)"example_parameter"));
    }
}

