/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.openidconnect;

import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.Clock;
import com.google.api.client.util.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class IdTokenVerifierTest
extends TestCase {
    private static final String CLIENT_ID = "myclientid";
    private static final String CLIENT_ID2 = "myclientid2";
    private static final List<String> TRUSTED_CLIENT_IDS = Arrays.asList("myclientid", "myclientid2");
    private static final String ISSUER = "issuer.example.com";
    private static final String ISSUER2 = "issuer.example.com2";
    private static final String ISSUER3 = "issuer.example.com3";

    private static IdToken newIdToken(String issuer, String audience) {
        IdToken.Payload payload = new IdToken.Payload();
        payload.setIssuer(issuer);
        payload.setAudience((Object)audience);
        payload.setExpirationTimeSeconds(Long.valueOf(2000L));
        payload.setIssuedAtTimeSeconds(Long.valueOf(1000L));
        return new IdToken(new JsonWebSignature.Header(), payload, new byte[0], new byte[0]);
    }

    public void testBuilder() throws Exception {
        IdTokenVerifier.Builder builder = new IdTokenVerifier.Builder().setIssuer(ISSUER).setAudience(TRUSTED_CLIENT_IDS);
        IdTokenVerifierTest.assertEquals((Object)Clock.SYSTEM, (Object)builder.getClock());
        IdTokenVerifierTest.assertEquals((String)ISSUER, (String)builder.getIssuer());
        IdTokenVerifierTest.assertEquals(Collections.singleton(ISSUER), (Object)builder.getIssuers());
        IdTokenVerifierTest.assertTrue((boolean)TRUSTED_CLIENT_IDS.equals(builder.getAudience()));
        MyClock clock = new MyClock();
        builder.setClock((Clock)clock);
        IdTokenVerifierTest.assertEquals((Object)clock, (Object)builder.getClock());
        IdTokenVerifier verifier = builder.build();
        IdTokenVerifierTest.assertEquals((Object)clock, (Object)verifier.getClock());
        IdTokenVerifierTest.assertEquals((String)ISSUER, (String)verifier.getIssuer());
        IdTokenVerifierTest.assertEquals(Collections.singleton(ISSUER), (Object)builder.getIssuers());
        IdTokenVerifierTest.assertEquals(TRUSTED_CLIENT_IDS, (Object)Lists.newArrayList((Iterable)verifier.getAudience()));
    }

    public void testVerify() throws Exception {
        MyClock clock = new MyClock();
        IdTokenVerifier verifier = new IdTokenVerifier.Builder().setIssuers(Arrays.asList(ISSUER, ISSUER3)).setAudience(Arrays.asList(CLIENT_ID)).setClock((Clock)clock).build();
        IdTokenVerifier verifierFlexible = new IdTokenVerifier.Builder().setClock((Clock)clock).build();
        clock.timeMillis = 1500000L;
        IdToken idToken = IdTokenVerifierTest.newIdToken(ISSUER, CLIENT_ID);
        IdTokenVerifierTest.assertTrue((boolean)verifier.verify(idToken));
        IdTokenVerifierTest.assertTrue((boolean)verifierFlexible.verify(IdTokenVerifierTest.newIdToken(ISSUER2, CLIENT_ID)));
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(IdTokenVerifierTest.newIdToken(ISSUER2, CLIENT_ID)));
        IdTokenVerifierTest.assertTrue((boolean)verifier.verify(IdTokenVerifierTest.newIdToken(ISSUER3, CLIENT_ID)));
        IdTokenVerifierTest.assertTrue((boolean)verifierFlexible.verify(IdTokenVerifierTest.newIdToken(ISSUER, CLIENT_ID2)));
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(IdTokenVerifierTest.newIdToken(ISSUER, CLIENT_ID2)));
        clock.timeMillis = 700000L;
        IdTokenVerifierTest.assertTrue((boolean)verifier.verify(idToken));
        clock.timeMillis = 2300000L;
        IdTokenVerifierTest.assertTrue((boolean)verifier.verify(idToken));
        clock.timeMillis = 699999L;
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken));
        clock.timeMillis = 2300001L;
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken));
    }

    public void testEmptyIssuersFails() throws Exception {
        IdTokenVerifier.Builder builder = new IdTokenVerifier.Builder();
        try {
            builder.setIssuers(Collections.emptyList());
            IdTokenVerifierTest.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuilderSetNullIssuers() throws Exception {
        IdTokenVerifier.Builder builder = new IdTokenVerifier.Builder();
        IdTokenVerifier verifier = builder.build();
        IdTokenVerifierTest.assertNull((Object)builder.getIssuers());
        IdTokenVerifierTest.assertNull((Object)builder.getIssuer());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuers());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuer());
        builder.setIssuers(null);
        verifier = builder.build();
        IdTokenVerifierTest.assertNull((Object)builder.getIssuers());
        IdTokenVerifierTest.assertNull((Object)builder.getIssuer());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuers());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuer());
        builder.setIssuer(null);
        verifier = builder.build();
        IdTokenVerifierTest.assertNull((Object)builder.getIssuers());
        IdTokenVerifierTest.assertNull((Object)builder.getIssuer());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuers());
        IdTokenVerifierTest.assertNull((Object)verifier.getIssuer());
    }

    public void testMissingAudience() {
        IdToken idToken = IdTokenVerifierTest.newIdToken(ISSUER, null);
        MyClock clock = new MyClock();
        clock.timeMillis = 1500000L;
        IdTokenVerifier verifier = new IdTokenVerifier.Builder().setIssuers(Arrays.asList(ISSUER, ISSUER3)).setAudience(Collections.emptyList()).setClock((Clock)clock).build();
        IdTokenVerifierTest.assertFalse((boolean)verifier.verify(idToken));
    }

    static class MyClock
    implements Clock {
        long timeMillis;

        MyClock() {
        }

        public long currentTimeMillis() {
            return this.timeMillis;
        }
    }
}

