/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth;

import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.auth.oauth.OAuthSigner;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;

public class OAuthParametersTest
extends TestCase {
    public void testEscape() {
        OAuthParametersTest.assertEquals((String)"abcdefghijklmnopqrstuvwxyz", (String)OAuthParameters.escape((String)"abcdefghijklmnopqrstuvwxyz"));
        OAuthParametersTest.assertEquals((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ", (String)OAuthParameters.escape((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        OAuthParametersTest.assertEquals((String)"01234567890", (String)OAuthParameters.escape((String)"01234567890"));
        OAuthParametersTest.assertEquals((String)"-_.~", (String)OAuthParameters.escape((String)"-_.~"));
        OAuthParametersTest.assertEquals((String)"%20%2B%25%3A%2F", (String)OAuthParameters.escape((String)" +%:/"));
    }

    public void testGetAuthorizationHeader() {
        OAuthParameters parameters = new OAuthParameters();
        parameters.verifier = "gZ1BFee1qSijpqbxfnX+o8rQ";
        parameters.consumerKey = "anonymous";
        parameters.nonce = "b51df3249df9dfd";
        parameters.signatureMethod = "HMAC-SHA1";
        parameters.timestamp = "1274732403";
        parameters.token = "4/1mZ3ZPynTry3szE49h3XyXk24p_I";
        parameters.signature = "OTfTeiNjKsNeqBtYhUPIiJO9pC4=";
        OAuthParametersTest.assertEquals((String)"OAuth oauth_consumer_key=\"anonymous\", oauth_nonce=\"b51df3249df9dfd\", oauth_signature=\"OTfTeiNjKsNeqBtYhUPIiJO9pC4%3D\", oauth_signature_method=\"HMAC-SHA1\", oauth_timestamp=\"1274732403\", oauth_token=\"4%2F1mZ3ZPynTry3szE49h3XyXk24p_I\", oauth_verifier=\"gZ1BFee1qSijpqbxfnX%2Bo8rQ\"", (String)parameters.getAuthorizationHeader());
    }

    public void testSignature() throws GeneralSecurityException {
        OAuthParameters parameters = new OAuthParameters();
        parameters.signer = new MockSigner();
        GenericUrl url = new GenericUrl("https://example.local?foo=bar");
        parameters.computeSignature("GET", url);
        OAuthParametersTest.assertEquals((String)"GET&https%3A%2F%2Fexample.local&foo%3Dbar%26oauth_signature_method%3Dmock", (String)parameters.signature);
    }

    public void testSignatureWithUrlEncodedContent() throws IOException {
        OAuthParameters parameters = new OAuthParameters();
        parameters.signer = new MockSigner();
        GenericUrl url = new GenericUrl("https://example.local?foo=bar");
        Map<String, String> contentParameters = Collections.singletonMap("this", "that");
        UrlEncodedContent content = new UrlEncodedContent(contentParameters);
        HttpRequest request = new NetHttpTransport.Builder().build().createRequestFactory().buildPostRequest(url, (HttpContent)content);
        parameters.intercept(request);
        OAuthParametersTest.assertTrue((boolean)parameters.signature.endsWith("%26this%3Dthat"));
        OAuthParametersTest.assertEquals((String)"https://example.local?foo=bar", (String)url.build());
    }

    public void testSignatureWithRepeatedParameter() throws GeneralSecurityException {
        OAuthParameters parameters = new OAuthParameters();
        parameters.signer = new MockSigner();
        GenericUrl url = new GenericUrl("https://example.local?foo=baz&foo=bar");
        parameters.computeSignature("GET", url);
        OAuthParametersTest.assertEquals((String)"GET&https%3A%2F%2Fexample.local&foo%3Dbar%26foo%3Dbaz%26oauth_signature_method%3Dmock", (String)parameters.signature);
    }

    static class MockSigner
    implements OAuthSigner {
        MockSigner() {
        }

        public String getSignatureMethod() {
            return "mock";
        }

        public String computeSignature(String signatureBaseString) {
            return signatureBaseString;
        }
    }
}

