/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth;

import com.google.api.client.auth.oauth.OAuthRsaSigner;
import com.google.api.client.util.Base64;
import com.google.api.client.util.SecurityUtils;
import com.google.api.client.util.StringUtils;
import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Signature;
import junit.framework.TestCase;

public class OAuthRsaSignerTest
extends TestCase {
    public void testComputeSignature() throws GeneralSecurityException {
        OAuthRsaSigner signer = new OAuthRsaSigner();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024);
        signer.privateKey = keyPairGenerator.genKeyPair().getPrivate();
        byte[] expected = SecurityUtils.sign((Signature)SecurityUtils.getSha1WithRsaSignatureAlgorithm(), (PrivateKey)signer.privateKey, (byte[])StringUtils.getBytesUtf8((String)"foo"));
        OAuthRsaSignerTest.assertEquals((String)Base64.encodeBase64String((byte[])expected), (String)signer.computeSignature("foo"));
    }
}

