/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.AuthenticationTestBase;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import java.util.Map;

public class CredentialTest
extends AuthenticationTestBase {
    public void testConstructor_header() throws Exception {
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken("abc");
        HttpRequest request = this.subtestConstructor(credential);
        CredentialTest.assertEquals((String)"Bearer abc", (String)request.getHeaders().getAuthorization());
    }

    public void testConstructor_queryParam() throws Exception {
        Credential credential = new Credential(BearerToken.queryParameterAccessMethod()).setAccessToken("abc");
        HttpRequest request = this.subtestConstructor(credential);
        CredentialTest.assertEquals((Object)"abc", (Object)request.getUrl().get((Object)"access_token"));
    }

    public void testConstructor_body() throws Exception {
        Credential credential = new Credential(BearerToken.formEncodedBodyAccessMethod()).setAccessToken("abc");
        HttpRequest request = this.subtestConstructor(credential);
        CredentialTest.assertEquals((Object)"abc", ((Map)((UrlEncodedContent)request.getContent()).getData()).get("access_token"));
    }

    private HttpRequest subtestConstructor(Credential credential) throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        HttpRequest request = requestFactory.buildDeleteRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.execute();
        return request;
    }

    public void testConstructor_expiredHeader() throws Exception {
        HttpRequest request = this.subtestConstructor_expired(BearerToken.authorizationHeaderAccessMethod(), new CheckAuth(){

            @Override
            public boolean checkAuth(MockLowLevelHttpRequest req) {
                return req.getFirstHeaderValue("Authorization").equals("Bearer def");
            }
        });
        CredentialTest.assertEquals((String)"Bearer def", (String)request.getHeaders().getAuthorization());
    }

    public void testConstructor_expiredQueryParam() throws Exception {
        HttpRequest request = this.subtestConstructor_expired(BearerToken.queryParameterAccessMethod(), new CheckAuth(){

            @Override
            public boolean checkAuth(MockLowLevelHttpRequest req) {
                return req.getUrl().contains("access_token=def");
            }
        });
        CredentialTest.assertEquals((Object)"def", (Object)request.getUrl().get((Object)"access_token"));
    }

    public void testConstructor_expiredBody() throws Exception {
        HttpRequest request = this.subtestConstructor_expired(BearerToken.formEncodedBodyAccessMethod(), new CheckAuth(){

            @Override
            public boolean checkAuth(MockLowLevelHttpRequest req) {
                return "def".equals(((Map)((UrlEncodedContent)req.getStreamingContent()).getData()).get("access_token"));
            }
        });
        CredentialTest.assertEquals((Object)"def", ((Map)((UrlEncodedContent)request.getContent()).getData()).get("access_token"));
    }

    private HttpRequest subtestConstructor_expired(Credential.AccessMethod method, final CheckAuth checkAuth) throws Exception {
        final Credential credential = new Credential.Builder(method).setTransport((HttpTransport)new AuthenticationTestBase.AccessTokenTransport()).setJsonFactory(JSON_FACTORY).setTokenServerUrl(TOKEN_SERVER_URL).setClientAuthentication((HttpExecuteInterceptor)new BasicAuthentication("id", "secret")).build().setAccessToken("abc").setRefreshToken("refreshToken");
        class MyTransport
        extends MockHttpTransport {
            boolean resetAccessToken;

            MyTransport() {
            }

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return new MockLowLevelHttpRequest(url){

                    public LowLevelHttpResponse execute() {
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                        if (!checkAuth.checkAuth(this)) {
                            response.setStatusCode(401);
                            if (resetAccessToken) {
                                credential.setAccessToken("def");
                            }
                        }
                        return response;
                    }
                };
            }
        }
        MyTransport transport = new MyTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        HttpRequest request = requestFactory.buildDeleteRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.execute();
        credential.setAccessToken("abc");
        transport.resetAccessToken = true;
        request.execute();
        return request;
    }

    public void testRefreshToken_noRefreshToken() throws Exception {
        Credential access = new Credential(BearerToken.queryParameterAccessMethod()).setAccessToken("abc");
        CredentialTest.assertFalse((boolean)access.refreshToken());
    }

    public void testRefreshToken_noRefreshToken2() throws Exception {
        AuthenticationTestBase.AccessTokenTransport transport = new AuthenticationTestBase.AccessTokenTransport();
        Credential access = new Credential.Builder(BearerToken.queryParameterAccessMethod()).setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).setTokenServerUrl(TOKEN_SERVER_URL).setClientAuthentication((HttpExecuteInterceptor)new BasicAuthentication("id", "secret")).build().setAccessToken("abc");
        CredentialTest.assertFalse((boolean)access.refreshToken());
        CredentialTest.assertEquals((String)"abc", (String)access.getAccessToken());
        CredentialTest.assertNull((Object)access.getRefreshToken());
        CredentialTest.assertNull((Object)access.getExpirationTimeMilliseconds());
    }

    public void testRefreshToken_refreshToken() throws Exception {
        AuthenticationTestBase.AccessTokenTransport transport = new AuthenticationTestBase.AccessTokenTransport();
        Credential access = new Credential.Builder(BearerToken.queryParameterAccessMethod()).setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).setTokenServerUrl(TOKEN_SERVER_URL).setClientAuthentication((HttpExecuteInterceptor)new BasicAuthentication("id", "secret")).build().setRefreshToken("refreshToken").setAccessToken("abc");
        CredentialTest.assertTrue((boolean)access.refreshToken());
        CredentialTest.assertEquals((String)"def", (String)access.getAccessToken());
        CredentialTest.assertEquals((String)"newRefreshToken", (String)access.getRefreshToken());
        CredentialTest.assertNotNull((Object)access.getExpirationTimeMilliseconds());
    }

    public void testRefreshToken_request_401() throws Exception {
        AuthenticationTestBase.AccessTokenTransport transport = new AuthenticationTestBase.AccessTokenTransport();
        transport.statusCode = 401;
        this.subtestRefreshToken_request(transport, 3);
    }

    public void testRefreshToken_request_www_authenticate() throws Exception {
        AuthenticationTestBase.AccessTokenTransport transport = new AuthenticationTestBase.AccessTokenTransport();
        transport.statusCode = 444;
        transport.wwwAuthenticate = "Bearer realm=\"https://www.google.com/accounts/AuthSubRequest\" error=invalid_token";
        this.subtestRefreshToken_request(transport, 3);
        transport = new AuthenticationTestBase.AccessTokenTransport();
        transport.statusCode = 401;
        transport.wwwAuthenticate = "Bearer error=invalid_token";
        this.subtestRefreshToken_request(transport, 3);
        transport = new AuthenticationTestBase.AccessTokenTransport();
        transport.statusCode = 401;
        transport.wwwAuthenticate = "doesn't contain b-e-a-r-e-r";
        this.subtestRefreshToken_request(transport, 3);
        transport = new AuthenticationTestBase.AccessTokenTransport();
        transport.statusCode = 401;
        transport.wwwAuthenticate = "Bearer blah blah blah";
        this.subtestRefreshToken_request(transport, 1);
        transport = new AuthenticationTestBase.AccessTokenTransport();
        transport.statusCode = 444;
        transport.wwwAuthenticate = "Bearer blah blah blah";
        this.subtestRefreshToken_request(transport, 1);
        transport = new AuthenticationTestBase.AccessTokenTransport();
        transport.statusCode = 444;
        transport.wwwAuthenticate = "doesn't contain b-e-a-r-e-r";
        this.subtestRefreshToken_request(transport, 1);
    }

    private void subtestRefreshToken_request(AuthenticationTestBase.AccessTokenTransport transport, int expectedCalls) throws Exception {
        Credential credential = new Credential.Builder(BearerToken.queryParameterAccessMethod()).setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).setTokenServerUrl(TOKEN_SERVER_URL).setClientAuthentication((HttpExecuteInterceptor)new BasicAuthentication("id", "secret")).build().setRefreshToken("refreshToken").setAccessToken("abc");
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        HttpRequest request = requestFactory.buildDeleteRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        request.execute();
        CredentialTest.assertEquals((int)expectedCalls, (int)transport.calls);
    }

    public void testRefreshToken_withoutRequiredParameters() {
        Credential access = new Credential(BearerToken.queryParameterAccessMethod());
        try {
            access.setRefreshToken("refreshToken");
            CredentialTest.fail((String)("Expected an " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRefreshToken_refreshTokenErrorWith400() throws Exception {
        AuthenticationTestBase.AccessTokenTransport transport = new AuthenticationTestBase.AccessTokenTransport();
        transport.statusCode = 400;
        Credential access = new Credential.Builder(BearerToken.queryParameterAccessMethod()).setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).setTokenServerUrl(TOKEN_SERVER_URL).setClientAuthentication((HttpExecuteInterceptor)new BasicAuthentication("id", "secret")).build().setExpiresInSeconds(Long.valueOf(3600L)).setAccessToken("abc").setRefreshToken("refreshToken");
        try {
            access.refreshToken();
            CredentialTest.fail((String)("Expected " + TokenResponseException.class));
        }
        catch (TokenResponseException tokenResponseException) {
            // empty catch block
        }
        CredentialTest.assertNull((Object)access.getAccessToken());
        CredentialTest.assertEquals((String)"refreshToken", (String)access.getRefreshToken());
        CredentialTest.assertNull((Object)access.getExpirationTimeMilliseconds());
    }

    public void testRefreshToken_refreshTokenErrorWith500() throws Exception {
        AuthenticationTestBase.AccessTokenTransport transport = new AuthenticationTestBase.AccessTokenTransport();
        transport.statusCode = 500;
        Credential access = new Credential.Builder(BearerToken.queryParameterAccessMethod()).setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).setTokenServerUrl(TOKEN_SERVER_URL).setClientAuthentication((HttpExecuteInterceptor)new BasicAuthentication("id", "secret")).build().setExpiresInSeconds(Long.valueOf(3600L)).setAccessToken("abc").setRefreshToken("refreshToken");
        CredentialTest.assertFalse((boolean)access.refreshToken());
        CredentialTest.assertNotNull((Object)access.getAccessToken());
        CredentialTest.assertEquals((String)"refreshToken", (String)access.getRefreshToken());
        CredentialTest.assertNotNull((Object)access.getExpirationTimeMilliseconds());
    }

    public void testInvalidTokenErrorMatcher() {
        String withQuote = "error = \"invalid_token\"";
        String withoutQuote = "error = invalid_token";
        CredentialTest.assertTrue((boolean)BearerToken.INVALID_TOKEN_ERROR.matcher(withQuote).find());
        CredentialTest.assertTrue((boolean)BearerToken.INVALID_TOKEN_ERROR.matcher(withoutQuote).find());
    }

    static interface CheckAuth {
        public boolean checkAuth(MockLowLevelHttpRequest var1);
    }
}

