/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import java.io.IOException;
import junit.framework.TestCase;

public class CustomTokenRequestTest
extends TestCase {
    private static final MockHttpTransport TRANSPORT = new MockHttpTransport();
    private static final GsonFactory JSON_FACTORY = new GsonFactory();
    private static final GenericUrl AUTHORIZATION_SERVER_URL = new GenericUrl("https://server.example.com/authorize");
    private static final String JWT_ENCODED_CONTENT = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c";

    public void testConstructorResponseClass() {
        TokenRequest request = new TokenRequest((HttpTransport)TRANSPORT, (JsonFactory)JSON_FACTORY, AUTHORIZATION_SERVER_URL, "foo", IdTokenResponse.class);
        CustomTokenRequestTest.assertEquals(IdTokenResponse.class, (Object)request.getResponseClass());
    }

    public void testSetResponseClass() throws IOException {
        TokenRequest request = new TokenRequest((HttpTransport)new AccessTokenTransport(), (JsonFactory)JSON_FACTORY, AUTHORIZATION_SERVER_URL, "foo").setResponseClass(IdTokenResponse.class);
        CustomTokenRequestTest.assertEquals(IdTokenResponse.class, (Object)request.getResponseClass());
        TokenResponse response = request.execute();
        CustomTokenRequestTest.assertTrue((boolean)(response instanceof IdTokenResponse));
        IdTokenResponse tokenResponse = (IdTokenResponse)response;
        IdToken idToken = tokenResponse.parseIdToken();
        CustomTokenRequestTest.assertEquals((Object)"John Doe", (Object)idToken.getPayload().get((Object)"name"));
    }

    static class AccessTokenTransport
    extends MockHttpTransport {
        AccessTokenTransport() {
        }

        public LowLevelHttpRequest buildRequest(String method, String url) {
            return new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.setContentType("application/json; charset=UTF-8");
                    IdTokenResponse json = new IdTokenResponse();
                    json.setAccessToken("abc");
                    json.setRefreshToken("def");
                    json.setExpiresInSeconds(Long.valueOf(3600L));
                    json.setIdToken(CustomTokenRequestTest.JWT_ENCODED_CONTENT);
                    response.setContent(JSON_FACTORY.toString((Object)json));
                    return response;
                }
            };
        }
    }
}

