/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import junit.framework.TestCase;

public class TokenRequestTest
extends TestCase {
    static final MockHttpTransport TRANSPORT = new MockHttpTransport();
    static final GsonFactory JSON_FACTORY = new GsonFactory();
    static final GenericUrl AUTHORIZATION_SERVER_URL = new GenericUrl("https://server.example.com/authorize");

    public void testConstructor() {
        TokenRequest request = new TokenRequest((HttpTransport)TRANSPORT, (JsonFactory)JSON_FACTORY, AUTHORIZATION_SERVER_URL, "foo");
        TokenRequestTest.check(request, "foo");
        TokenRequestTest.assertEquals(TokenResponse.class, (Object)request.getResponseClass());
    }

    static void check(TokenRequest request, String grantType) {
        TokenRequestTest.assertEquals((String)grantType, (String)request.getGrantType());
        TokenRequestTest.assertNull((Object)request.getScopes());
        TokenRequestTest.assertEquals((Object)TRANSPORT, (Object)request.getTransport());
        TokenRequestTest.assertEquals((Object)JSON_FACTORY, (Object)request.getJsonFactory());
        TokenRequestTest.assertEquals((Object)AUTHORIZATION_SERVER_URL, (Object)request.getTokenServerUrl());
    }

    public void testScopes() throws IOException {
        TokenRequest request = new TokenRequest((HttpTransport)TRANSPORT, (JsonFactory)JSON_FACTORY, AUTHORIZATION_SERVER_URL, "foo").setScopes((Collection)ImmutableList.of((Object)"scope1"));
        UrlEncodedContent content = new UrlEncodedContent((Object)request);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        content.writeTo((OutputStream)outputStream);
        String encoded = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
        TokenRequestTest.assertEquals((String)"grant_type=foo&scope=scope1", (String)encoded);
    }

    public void testEmptyScopes() throws IOException {
        TokenRequest request = new TokenRequest((HttpTransport)TRANSPORT, (JsonFactory)JSON_FACTORY, AUTHORIZATION_SERVER_URL, "foo").setScopes((Collection)ImmutableList.of());
        UrlEncodedContent content = new UrlEncodedContent((Object)request);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        content.writeTo((OutputStream)outputStream);
        String encoded = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
        TokenRequestTest.assertEquals((String)"grant_type=foo&scope", (String)encoded);
    }

    public void testNullScopes() throws IOException {
        TokenRequest request = new TokenRequest((HttpTransport)TRANSPORT, (JsonFactory)JSON_FACTORY, AUTHORIZATION_SERVER_URL, "foo").setScopes(null);
        UrlEncodedContent content = new UrlEncodedContent((Object)request);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        content.writeTo((OutputStream)outputStream);
        String encoded = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
        TokenRequestTest.assertEquals((String)"grant_type=foo", (String)encoded);
    }
}

