/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector.junit5;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.testing.junit.testparameterinjector.junit5.TestParameterValidator;
import java.lang.annotation.Annotation;
import java.util.List;

abstract class BaseTestParameterValidator
implements TestParameterValidator {
    BaseTestParameterValidator() {
    }

    @Override
    public boolean shouldSkip(TestParameterValidator.Context context) {
        for (List<Class<? extends Annotation>> parameters : this.getIndependentParameters(context)) {
            Preconditions.checkArgument((!parameters.isEmpty() ? 1 : 0) != 0);
            Class leadingParameter = (Class)FluentIterable.from(parameters).toSortedList((o1, o2) -> Integer.compare(context.getSpecifiedValues((Class<? extends Annotation>)o1).size(), context.getSpecifiedValues((Class<? extends Annotation>)o2).size())).reverse().get(0);
            int leadingParameterValueIndex = this.getValueIndex(context, leadingParameter, context.getValue(leadingParameter).get());
            Preconditions.checkState((leadingParameterValueIndex >= 0 ? 1 : 0) != 0);
            for (Class<? extends Annotation> parameter : parameters) {
                int requiredValueIndex;
                List<Object> specifiedValues = context.getSpecifiedValues(parameter);
                int valueIndex = specifiedValues.indexOf(context.getValue(parameter).get());
                if (valueIndex == (requiredValueIndex = Math.min(leadingParameterValueIndex, specifiedValues.size() - 1))) continue;
                return true;
            }
        }
        return false;
    }

    private int getValueIndex(TestParameterValidator.Context context, Class<? extends Annotation> annotation, Object value) {
        return context.getSpecifiedValues(annotation).indexOf(value);
    }

    protected abstract List<List<Class<? extends Annotation>>> getIndependentParameters(TestParameterValidator.Context var1);
}

