/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector.junit5;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.testing.junit.testparameterinjector.junit5.AutoValue_ExecutableValidationResult;
import java.util.Collection;

@AutoValue
abstract class ExecutableValidationResult {
    ExecutableValidationResult() {
    }

    public abstract boolean wasValidated();

    public abstract ImmutableList<Throwable> validationErrors();

    static ExecutableValidationResult notValidated() {
        return ExecutableValidationResult.of(false, (Collection<Throwable>)ImmutableList.of());
    }

    static ExecutableValidationResult validated(Collection<Throwable> errors) {
        return ExecutableValidationResult.of(true, errors);
    }

    static ExecutableValidationResult validated(Throwable error) {
        return ExecutableValidationResult.of(true, (Collection<Throwable>)ImmutableList.of((Object)error));
    }

    static ExecutableValidationResult valid() {
        return ExecutableValidationResult.of(true, (Collection<Throwable>)ImmutableList.of());
    }

    private static ExecutableValidationResult of(boolean wasValidated, Collection<Throwable> validationErrors) {
        Preconditions.checkArgument((wasValidated || validationErrors.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_ExecutableValidationResult(wasValidated, (ImmutableList<Throwable>)ImmutableList.copyOf(validationErrors));
    }

    void assertValid() {
        if (this.wasValidated() && !this.validationErrors().isEmpty()) {
            if (this.validationErrors().size() == 1) {
                throw new AssertionError(Iterables.getOnlyElement(this.validationErrors()));
            }
            throw new AssertionError((Object)String.format("Found validation errors: %s", this.validationErrors()));
        }
    }
}

