/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector.junit5;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedLong;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.junit.testparameterinjector.junit5.ByteStringReflection;
import com.google.testing.junit.testparameterinjector.junit5.TestParameterValue;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

final class ParameterValueParsing {
    static <E extends Enum<E>> Enum<?> parseEnum(String str, Class<?> enumType) {
        return Enum.valueOf(enumType, str);
    }

    static boolean isValidYamlString(String yamlString) {
        try {
            new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(yamlString);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    static Object parseYamlStringToJavaType(String yamlString, Class<?> javaType) {
        return ParameterValueParsing.parseYamlObjectToJavaType(ParameterValueParsing.parseYamlStringToObject(yamlString), TypeToken.of(javaType));
    }

    static Object parseYamlStringToObject(String yamlString) {
        return new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(yamlString);
    }

    private static UnsignedLong parseYamlSignedLongToUnsignedLong(long number) {
        Preconditions.checkState((number >= 0L ? 1 : 0) != 0, (String)"%s should be greater than or equal to zero", (long)number);
        return UnsignedLong.fromLongBits((long)number);
    }

    static Object parseYamlObjectToJavaType(Object parsedYaml, TypeToken<?> javaType) {
        if (parsedYaml == null) {
            return null;
        }
        YamlValueTransformer yamlValueTransformer = new YamlValueTransformer(parsedYaml, javaType.getRawType());
        yamlValueTransformer.ifJavaType(String.class).supportParsedType(String.class, self -> self).supportParsedType(Boolean.class, Object::toString).supportParsedType(Integer.class, Object::toString).supportParsedType(Long.class, Object::toString).supportParsedType(Double.class, Object::toString);
        yamlValueTransformer.ifJavaType(Boolean.class).supportParsedType(Boolean.class, self -> self);
        yamlValueTransformer.ifJavaType(Integer.class).supportParsedType(Integer.class, self -> self);
        yamlValueTransformer.ifJavaType(Long.class).supportParsedType(Long.class, self -> self).supportParsedType(Integer.class, Integer::longValue);
        yamlValueTransformer.ifJavaType(UnsignedLong.class).supportParsedType(Long.class, self -> ParameterValueParsing.parseYamlSignedLongToUnsignedLong(self)).supportParsedType(Integer.class, self -> ParameterValueParsing.parseYamlSignedLongToUnsignedLong(self.longValue())).supportParsedType(BigInteger.class, UnsignedLong::valueOf);
        yamlValueTransformer.ifJavaType(BigInteger.class).supportParsedType(Long.class, self -> BigInteger.valueOf(self)).supportParsedType(Integer.class, self -> BigInteger.valueOf(self.longValue())).supportParsedType(BigInteger.class, self -> self);
        yamlValueTransformer.ifJavaType(Float.class).supportParsedType(Float.class, self -> self).supportParsedType(Double.class, Double::floatValue).supportParsedType(Integer.class, Integer::floatValue).supportParsedType(String.class, Float::valueOf);
        yamlValueTransformer.ifJavaType(Double.class).supportParsedType(Double.class, self -> self).supportParsedType(Integer.class, Integer::doubleValue).supportParsedType(Long.class, Long::doubleValue).supportParsedType(String.class, Double::valueOf);
        yamlValueTransformer.ifJavaType(Enum.class).supportParsedType(String.class, str -> ParameterValueParsing.parseEnum(str, javaType.getRawType()));
        yamlValueTransformer.ifJavaType(byte[].class).supportParsedType(byte[].class, self -> self).supportParsedType(String.class, s -> s.getBytes(Charset.forName("UTF-8")));
        if (ByteStringReflection.MAYBE_BYTE_STRING_CLASS.isPresent()) {
            yamlValueTransformer.ifJavaType((Class)ByteStringReflection.MAYBE_BYTE_STRING_CLASS.get()).supportParsedType(String.class, ByteStringReflection::copyFromUtf8).supportParsedType(byte[].class, ByteStringReflection::copyFrom);
        }
        yamlValueTransformer.ifJavaType(List.class).supportParsedType(List.class, list -> Lists.transform((List)list, e -> ParameterValueParsing.parseYamlObjectToJavaType(e, ParameterValueParsing.getGenericParameterType(javaType, 0))));
        yamlValueTransformer.ifJavaType(Map.class).supportParsedType(Map.class, map -> ParameterValueParsing.parseYamlMapToJavaMap(map, javaType));
        return yamlValueTransformer.transformedJavaValue();
    }

    private static Map<?, ?> parseYamlMapToJavaMap(Map<?, ?> map, TypeToken<?> javaType) {
        LinkedHashMap<Object, Object> returnedMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            returnedMap.put(ParameterValueParsing.parseYamlObjectToJavaType(entry.getKey(), ParameterValueParsing.getGenericParameterType(javaType, 0)), ParameterValueParsing.parseYamlObjectToJavaType(entry.getValue(), ParameterValueParsing.getGenericParameterType(javaType, 1)));
        }
        return returnedMap;
    }

    private static TypeToken<?> getGenericParameterType(TypeToken<?> typeToken, int parameterIndex) {
        Preconditions.checkArgument((boolean)(typeToken.getType() instanceof ParameterizedType), (String)"Could not parse the generic parameter of type %s", typeToken);
        ParameterizedType parameterizedType = (ParameterizedType)typeToken.getType();
        return TypeToken.of((Type)parameterizedType.getActualTypeArguments()[parameterIndex]);
    }

    static String formatTestNameString(Optional<String> parameterName, @Nullable Object value) {
        Optional<String> customName;
        Object unwrappedValue;
        if (value instanceof TestParameterValue) {
            TestParameterValue tpValue = (TestParameterValue)value;
            unwrappedValue = tpValue.getWrappedValue();
            customName = tpValue.getCustomName();
        } else {
            unwrappedValue = value;
            customName = Optional.absent();
        }
        String result = (String)customName.or(() -> ParameterValueParsing.valueAsString(unwrappedValue));
        if (parameterName.isPresent() && !customName.isPresent() && (unwrappedValue == null || Primitives.unwrap(unwrappedValue.getClass()).isPrimitive() || unwrappedValue.equals("null") || unwrappedValue instanceof CharSequence && CharMatcher.anyOf((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ").matchesNoneOf((CharSequence)unwrappedValue))) {
            result = String.format("%s=%s", parameterName.get(), ParameterValueParsing.valueAsString(unwrappedValue));
        }
        return result.trim().replaceAll("\\s+", " ");
    }

    private static String valueAsString(Object value) {
        if (value != null && value.getClass().isArray()) {
            StringBuilder resultBuider = new StringBuilder();
            resultBuider.append("[");
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (i > 0) {
                    resultBuider.append(", ");
                }
                resultBuider.append(Array.get(value, i));
            }
            resultBuider.append("]");
            return resultBuider.toString();
        }
        if (ByteStringReflection.isInstanceOfByteString(value)) {
            return Arrays.toString(ByteStringReflection.byteStringToByteArray(value));
        }
        return String.valueOf(value);
    }

    private ParameterValueParsing() {
    }

    private static final class YamlValueTransformer {
        private final Object parsedYaml;
        private final Class<?> javaType;
        @Nullable
        private Object transformedJavaValue;

        YamlValueTransformer(Object parsedYaml, Class<?> javaType) {
            this.parsedYaml = parsedYaml;
            this.javaType = javaType;
        }

        <JavaT> SupportedJavaType<JavaT> ifJavaType(Class<JavaT> supportedJavaType) {
            return new SupportedJavaType(supportedJavaType);
        }

        Object transformedJavaValue() {
            Preconditions.checkArgument((this.transformedJavaValue != null ? 1 : 0) != 0, (String)"Could not map YAML value %s (class = %s) to java class %s", (Object)this.parsedYaml, this.parsedYaml.getClass(), this.javaType);
            return this.transformedJavaValue;
        }

        final class SupportedJavaType<JavaT> {
            private final Class<JavaT> supportedJavaType;

            private SupportedJavaType(Class<JavaT> supportedJavaType) {
                this.supportedJavaType = supportedJavaType;
            }

            @CanIgnoreReturnValue
            <ParsedYamlT> SupportedJavaType<JavaT> supportParsedType(Class<ParsedYamlT> parsedYamlType, Function<ParsedYamlT, JavaT> transformation) {
                if (Primitives.wrap(this.supportedJavaType).isAssignableFrom(Primitives.wrap((Class)YamlValueTransformer.this.javaType)) && Primitives.wrap(parsedYamlType).isInstance(YamlValueTransformer.this.parsedYaml)) {
                    Preconditions.checkState((YamlValueTransformer.this.transformedJavaValue == null ? 1 : 0) != 0, (Object)"This case is already handled. This is a bug in testparameterinjector.TestParametersMethodProcessor.");
                    try {
                        YamlValueTransformer.this.transformedJavaValue = Preconditions.checkNotNull((Object)transformation.apply(YamlValueTransformer.this.parsedYaml));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Could not map YAML value %s (class = %s) to java class %s", YamlValueTransformer.this.parsedYaml, YamlValueTransformer.this.parsedYaml.getClass(), YamlValueTransformer.this.javaType), e);
                    }
                }
                return this;
            }
        }
    }
}

