/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector.junit5;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.testing.junit.testparameterinjector.junit5.ExecutableValidationResult;
import com.google.testing.junit.testparameterinjector.junit5.TestInfo;
import com.google.testing.junit.testparameterinjector.junit5.TestMethodProcessor;
import com.google.testing.junit.testparameterinjector.junit5.TestParameterAnnotationMethodProcessor;
import com.google.testing.junit.testparameterinjector.junit5.TestParametersMethodProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

final class TestMethodProcessorList {
    private final ImmutableList<TestMethodProcessor> testMethodProcessors;

    private TestMethodProcessorList(ImmutableList<TestMethodProcessor> testMethodProcessors) {
        this.testMethodProcessors = testMethodProcessors;
    }

    public static TestMethodProcessorList createNewParameterizedProcessors() {
        return new TestMethodProcessorList((ImmutableList<TestMethodProcessor>)ImmutableList.of((Object)new TestParametersMethodProcessor(), (Object)TestParameterAnnotationMethodProcessor.onlyForFieldsAndParameters()));
    }

    static TestMethodProcessorList empty() {
        return new TestMethodProcessorList((ImmutableList<TestMethodProcessor>)ImmutableList.of());
    }

    public List<TestInfo> calculateTestInfos(Method testMethod, Class<?> testClass) {
        Object testInfos = ImmutableList.of((Object)TestInfo.createWithoutParameters(testMethod, testClass, (List<Annotation>)ImmutableList.copyOf((Object[])testMethod.getAnnotations())));
        for (TestMethodProcessor testMethodProcessor : this.testMethodProcessors) {
            ArrayList<TestInfo> list = new ArrayList<TestInfo>();
            for (TestInfo lastTestInfo : testInfos) {
                list.addAll(testMethodProcessor.calculateTestInfos(lastTestInfo));
            }
            testInfos = list;
        }
        testInfos = TestInfo.deduplicateTestNames(TestInfo.shortenNamesIfNecessary((List<TestInfo>)testInfos));
        return testInfos;
    }

    public List<Object> getConstructorParameters(Constructor<?> constructor, TestInfo testInfo) {
        return (List)FluentIterable.from(this.testMethodProcessors).transform(processor -> processor.maybeGetConstructorParameters(constructor, testInfo)).filter(Optional::isPresent).transform(Optional::get).first().or(() -> {
            throw new IllegalStateException(String.format("Could not generate parameter values for %s. Did you forget an annotation?", constructor));
        });
    }

    public List<Object> getTestMethodParameters(TestInfo testInfo) {
        return (List)FluentIterable.from(this.testMethodProcessors).transform(processor -> processor.maybeGetTestMethodParameters(testInfo)).filter(Optional::isPresent).transform(Optional::get).first().or(() -> {
            throw new IllegalStateException(String.format("Could not generate parameter values for %s. Did you forget an annotation?", testInfo.getMethod()));
        });
    }

    public void postProcessTestInstance(Object testInstance, TestInfo testInfo) {
        for (TestMethodProcessor testMethodProcessor : this.testMethodProcessors) {
            testMethodProcessor.postProcessTestInstance(testInstance, testInfo);
        }
    }

    public ExecutableValidationResult validateConstructor(Constructor<?> constructor) {
        return (ExecutableValidationResult)FluentIterable.from(this.testMethodProcessors).transform(processor -> processor.validateConstructor(constructor)).firstMatch(ExecutableValidationResult::wasValidated).or((Object)ExecutableValidationResult.notValidated());
    }

    public ExecutableValidationResult validateTestMethod(Method testMethod, Class<?> testClass) {
        return (ExecutableValidationResult)FluentIterable.from(this.testMethodProcessors).transform(processor -> processor.validateTestMethod(testMethod, testClass)).firstMatch(ExecutableValidationResult::wasValidated).or((Object)ExecutableValidationResult.notValidated());
    }
}

