/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector.junit5;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.testing.junit.testparameterinjector.junit5.AutoValue_TestParameterInjectorExtension_CustomInvocationContext;
import com.google.testing.junit.testparameterinjector.junit5.TestInfo;
import com.google.testing.junit.testparameterinjector.junit5.TestMethodProcessorList;
import com.google.testing.junit.testparameterinjector.junit5.TestParameterInjectorTest;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

class TestParameterInjectorExtension
implements TestTemplateInvocationContextProvider {
    private static final TestMethodProcessorList testMethodProcessors = TestMethodProcessorList.createNewParameterizedProcessors();

    TestParameterInjectorExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        this.validateTestMethodAndConstructor(extensionContext.getRequiredTestMethod(), extensionContext.getRequiredTestClass());
        List<TestInfo> testInfos = testMethodProcessors.calculateTestInfos(extensionContext.getRequiredTestMethod(), extensionContext.getRequiredTestClass());
        return testInfos.stream().map(CustomInvocationContext::of);
    }

    private void validateTestMethodAndConstructor(Method testMethod, Class<?> testClass) {
        Preconditions.checkState((testClass.getDeclaredConstructors().length == 1 ? 1 : 0) != 0, (String)"Only a single constructor is allowed, but found %s in %s", (int)testClass.getDeclaredConstructors().length, (Object)testClass.getSimpleName());
        Constructor constructor = (Constructor)Iterables.getOnlyElement((Iterable)ImmutableList.copyOf((Object[])testClass.getDeclaredConstructors()));
        testMethodProcessors.validateConstructor(constructor).assertValid();
        testMethodProcessors.validateTestMethod(testMethod, testClass).assertValid();
        Preconditions.checkState((testMethod.getAnnotation(TestParameterInjectorTest.class) != null ? 1 : 0) != 0, (Object)"Each test method handled by this extension should be annotated with @TestParameterInjectorTest");
    }

    @AutoValue
    static abstract class CustomInvocationContext
    implements TestTemplateInvocationContext {
        CustomInvocationContext() {
        }

        abstract TestInfo testInfo();

        @Memoized
        List<Object> getConstructorParameters() {
            Constructor constructor = (Constructor)Iterables.getOnlyElement((Iterable)ImmutableList.copyOf((Object[])this.testInfo().getTestClass().getDeclaredConstructors()));
            return testMethodProcessors.getConstructorParameters(constructor, this.testInfo());
        }

        @Memoized
        List<Object> getTestMethodParameters() {
            return testMethodProcessors.getTestMethodParameters(this.testInfo());
        }

        static CustomInvocationContext of(TestInfo testInfo) {
            return new AutoValue_TestParameterInjectorExtension_CustomInvocationContext(testInfo);
        }

        public String getDisplayName(int invocationIndex) {
            return this.testInfo().getName();
        }

        public List<Extension> getAdditionalExtensions() {
            return ImmutableList.of((Object)new CustomAdditionalExtension());
        }

        class CustomAdditionalExtension
        implements ParameterResolver,
        TestInstancePostProcessor {
            CustomAdditionalExtension() {
            }

            public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                if (parameterContext.getDeclaringExecutable() instanceof Constructor) {
                    return true;
                }
                return parameterContext.getDeclaringExecutable().isAnnotationPresent(TestParameterInjectorTest.class);
            }

            public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                if (parameterContext.getDeclaringExecutable() instanceof Constructor) {
                    return CustomInvocationContext.this.getConstructorParameters().get(parameterContext.getIndex());
                }
                return CustomInvocationContext.this.getTestMethodParameters().get(parameterContext.getIndex());
            }

            public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
                testMethodProcessors.postProcessTestInstance(testInstance, CustomInvocationContext.this.testInfo());
            }
        }
    }
}

