/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector.junit5;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.testing.junit.testparameterinjector.junit5.TestParameter;
import com.google.testing.junit.testparameterinjector.junit5.TestParameterValue;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Nullable;

public abstract class TestParameterValuesProvider
implements TestParameter.TestParameterValuesProvider {
    protected abstract List<?> provideValues(Context var1) throws Exception;

    @Override
    public final List<?> provideValues() {
        throw new UnsupportedOperationException("The TestParameterInjector framework should never call this method, and instead call #provideValues(Context)");
    }

    @Override
    public final TestParameterValue value(@Nullable Object wrappedValue) {
        return TestParameter.TestParameterValuesProvider.super.value(wrappedValue);
    }

    public static final class Context {
        private final ImmutableList<Annotation> otherAnnotations;
        private final Class<?> testClass;

        Context(ImmutableList<Annotation> otherAnnotations, Class<?> testClass) {
            this.otherAnnotations = otherAnnotations;
            this.testClass = testClass;
        }

        public <A extends Annotation> A getOtherAnnotation(Class<A> annotationType) {
            Preconditions.checkArgument((!TestParameter.class.equals(annotationType) ? 1 : 0) != 0, (Object)"Getting the @TestParameter annotating the field or parameter is not allowed because it is already handled by the TestParameterInjector framework.");
            return (A)((Annotation)Iterables.getOnlyElement((Iterable)FluentIterable.from(this.otherAnnotations()).filter(annotation -> annotation.annotationType().equals(annotationType)).toList()));
        }

        public Class<?> testClass() {
            return this.testClass;
        }

        @VisibleForTesting
        ImmutableList<Annotation> otherAnnotations() {
            return this.otherAnnotations;
        }

        public String toString() {
            return String.format("Context(otherAnnotations=[%s],testClass=%s)", FluentIterable.from(this.otherAnnotations()).join(Joiner.on((char)',')), this.testClass().getSimpleName());
        }
    }
}

