/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.base;

import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.OutputType;
import com.google.visualization.datasource.base.ReasonType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceParameters {
    private static final Log log = LogFactory.getLog((String)DataSourceParameters.class.getName());
    private static final String REQUEST_ID_PARAM_NAME = "reqId";
    private static final String SIGNATURE_PARAM_NAME = "sig";
    private static final String OUTPUT_TYPE_PARAM_NAME = "out";
    private static final String RESPONSE_HANDLER_PARAM_NAME = "responseHandler";
    private static final String REQUEST_OUTFILENAME_PARAM_NAME = "outFileName";
    private static final String DEFAULT_ERROR_MSG = "Internal error";
    private String tqxValue = null;
    private String requestId = null;
    private String signature = null;
    private OutputType outputType = OutputType.defaultValue();
    private String responseHandler = "google.visualization.Query.setResponse";
    private String outFileName = "data.csv";

    public static DataSourceParameters getDefaultDataSourceParameters() {
        DataSourceParameters dataSourceParameters = null;
        try {
            dataSourceParameters = new DataSourceParameters(null);
        }
        catch (DataSourceException dataSourceException) {
            // empty catch block
        }
        return dataSourceParameters;
    }

    public DataSourceParameters(String string) throws DataSourceException {
        String[] stringArray;
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        this.tqxValue = string;
        for (String string2 : stringArray = string.split(";")) {
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length != 2) {
                log.error((Object)("Invalid name-value pair: " + string2));
                throw new DataSourceException(ReasonType.INVALID_REQUEST, "Internal error(malformed)");
            }
            String string3 = stringArray2[0];
            String string4 = stringArray2[1];
            if (string3.equals(REQUEST_ID_PARAM_NAME)) {
                this.requestId = string4;
                continue;
            }
            if (string3.equals(SIGNATURE_PARAM_NAME)) {
                this.signature = string4;
                continue;
            }
            if (string3.equals(OUTPUT_TYPE_PARAM_NAME)) {
                this.outputType = OutputType.findByCode(string4);
                if (this.outputType != null) continue;
                this.outputType = OutputType.defaultValue();
                continue;
            }
            if (string3.equals(RESPONSE_HANDLER_PARAM_NAME)) {
                this.responseHandler = string4;
                continue;
            }
            if (!string3.equals(REQUEST_OUTFILENAME_PARAM_NAME)) continue;
            this.outFileName = string4;
            if (this.outFileName.contains(".")) continue;
            this.outFileName = this.outFileName + ".csv";
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String string) {
        this.signature = string;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public String getResponseHandler() {
        return this.responseHandler;
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public String getTqxValue() {
        return this.tqxValue;
    }
}

