/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.BooleanFormat;
import com.google.visualization.datasource.base.LocaleUtil;
import com.google.visualization.datasource.base.TextFormat;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ValueFormatter {
    private UFormat uFormat;
    private String pattern;
    private ULocale locale;
    private ValueType type;
    private static final String DEFAULT_TEXT_DUMMY_PATTERN = "dummy";
    private static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DEFAULT_DATE_PATTERNS = "yyyy-MM-dd";
    private static final String DEFAULT_TIMEOFDAY_PATTERN = "HH:mm:ss";
    private static final String DEFAULT_BOOLEAN_PATTERN = "true:false";
    private static final String DEFAULT_NUMBER_PATTERN = "";

    private ValueFormatter(String string, UFormat uFormat, ValueType valueType, ULocale uLocale) {
        this.pattern = string;
        this.uFormat = uFormat;
        this.type = valueType;
        this.locale = uLocale;
    }

    public static ValueFormatter createFromPattern(ValueType valueType, String string, ULocale uLocale) {
        UFormat uFormat = null;
        if (string == null) {
            string = ValueFormatter.getDefaultPatternByType(valueType);
        }
        if (uLocale == null) {
            uLocale = LocaleUtil.getDefaultLocale();
        }
        try {
            switch (valueType) {
                case BOOLEAN: {
                    uFormat = new BooleanFormat(string);
                    uFormat.format((Object)BooleanValue.TRUE.getObjectToFormat());
                    break;
                }
                case TEXT: {
                    uFormat = new TextFormat();
                    break;
                }
                case DATE: {
                    uFormat = new SimpleDateFormat(string, uLocale);
                    ((SimpleDateFormat)uFormat).setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                    uFormat.format((Object)new DateValue(1995, 7, 3).getObjectToFormat());
                    break;
                }
                case TIMEOFDAY: {
                    uFormat = new SimpleDateFormat(string, uLocale);
                    ((SimpleDateFormat)uFormat).setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                    uFormat.format((Object)new TimeOfDayValue(2, 59, 12, 123).getObjectToFormat());
                    break;
                }
                case DATETIME: {
                    uFormat = new SimpleDateFormat(string, uLocale);
                    ((SimpleDateFormat)uFormat).setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                    uFormat.format((Object)new DateTimeValue(1995, 7, 3, 2, 59, 12, 123).getObjectToFormat());
                    break;
                }
                case NUMBER: {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(uLocale);
                    uFormat = new DecimalFormat(string, decimalFormatSymbols);
                    uFormat.format((Object)new NumberValue(-12.3).getObjectToFormat());
                }
            }
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        return new ValueFormatter(string, uFormat, valueType, uLocale);
    }

    public static ValueFormatter createDefault(ValueType valueType, ULocale uLocale) {
        String string = ValueFormatter.getDefaultPatternByType(valueType);
        return ValueFormatter.createFromPattern(valueType, string, uLocale);
    }

    public static Map<ValueType, ValueFormatter> createDefaultFormatters(ULocale uLocale) {
        HashMap hashMap = Maps.newHashMap();
        for (ValueType valueType : ValueType.values()) {
            hashMap.put(valueType, ValueFormatter.createDefault(valueType, uLocale));
        }
        return hashMap;
    }

    public String format(Value value) {
        if (value.isNull()) {
            return DEFAULT_NUMBER_PATTERN;
        }
        return this.uFormat.format(value.getObjectToFormat());
    }

    public Value parse(String string) {
        Value value = null;
        try {
            switch (this.type) {
                case DATE: {
                    value = this.parseDate(string);
                    break;
                }
                case TIMEOFDAY: {
                    value = this.parseTimeOfDay(string);
                    break;
                }
                case DATETIME: {
                    value = this.parseDateTime(string);
                    break;
                }
                case NUMBER: {
                    value = this.parseNumber(string);
                    break;
                }
                case BOOLEAN: {
                    value = this.parseBoolean(string);
                    break;
                }
                case TEXT: {
                    value = new TextValue(string);
                }
            }
        }
        catch (ParseException parseException) {
            value = Value.getNullValueFromValueType(this.type);
        }
        return value;
    }

    private static String getDefaultPatternByType(ValueType valueType) {
        String string;
        switch (valueType) {
            case TEXT: {
                string = DEFAULT_TEXT_DUMMY_PATTERN;
                break;
            }
            case DATE: {
                string = DEFAULT_DATE_PATTERNS;
                break;
            }
            case DATETIME: {
                string = DEFAULT_DATETIME_PATTERN;
                break;
            }
            case TIMEOFDAY: {
                string = DEFAULT_TIMEOFDAY_PATTERN;
                break;
            }
            case BOOLEAN: {
                string = DEFAULT_BOOLEAN_PATTERN;
                break;
            }
            case NUMBER: {
                string = DEFAULT_NUMBER_PATTERN;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private BooleanValue parseBoolean(String string) throws ParseException {
        Boolean bl = ((BooleanFormat)this.uFormat).parse(string);
        return BooleanValue.getInstance(bl);
    }

    private NumberValue parseNumber(String string) throws ParseException {
        Number number = ((NumberFormat)this.uFormat).parse(string);
        return new NumberValue(number.doubleValue());
    }

    private DateTimeValue parseDateTime(String string) throws ParseException {
        Date date = ((SimpleDateFormat)this.uFormat).parse(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        gregorianCalendar.setTime(date);
        return new DateTimeValue(gregorianCalendar);
    }

    private DateValue parseDate(String string) throws ParseException {
        Date date = ((SimpleDateFormat)this.uFormat).parse(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        gregorianCalendar.setTime(date);
        return new DateValue(gregorianCalendar);
    }

    private TimeOfDayValue parseTimeOfDay(String string) throws ParseException {
        Date date = ((SimpleDateFormat)this.uFormat).parse(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
        gregorianCalendar.setTime(date);
        return new TimeOfDayValue(gregorianCalendar);
    }

    public UFormat getUFormat() {
        return this.uFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public ValueType getType() {
        return this.type;
    }
}

