/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ComparisonFilter;
import com.google.visualization.datasource.query.DataTableColumnLookup;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.List;
import java.util.Set;

public class ColumnValueFilter
extends ComparisonFilter {
    private AbstractColumn column;
    private Value value;
    private boolean isComparisonOrderReversed;

    public ColumnValueFilter(AbstractColumn abstractColumn, Value value, ComparisonFilter.Operator operator, boolean bl) {
        super(operator);
        this.column = abstractColumn;
        this.value = value;
        this.isComparisonOrderReversed = bl;
    }

    public ColumnValueFilter(AbstractColumn abstractColumn, Value value, ComparisonFilter.Operator operator) {
        this(abstractColumn, value, operator, false);
    }

    @Override
    public boolean isMatch(DataTable dataTable, TableRow tableRow) {
        DataTableColumnLookup dataTableColumnLookup = new DataTableColumnLookup(dataTable);
        Value value = this.column.getValue(dataTableColumnLookup, tableRow);
        return this.isComparisonOrderReversed ? this.isOperatorMatch(this.value, value) : this.isOperatorMatch(value, this.value);
    }

    @Override
    public Set<String> getAllColumnIds() {
        return Sets.newHashSet(this.column.getAllSimpleColumnIds());
    }

    @Override
    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        return this.column.getAllScalarFunctionColumns();
    }

    @Override
    protected List<AggregationColumn> getAggregationColumns() {
        return this.column.getAllAggregationColumns();
    }

    public AbstractColumn getColumn() {
        return this.column;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isComparisonOrderReversed() {
        return this.isComparisonOrderReversed;
    }

    @Override
    public String toQueryString() {
        if (this.isComparisonOrderReversed) {
            return this.value.toQueryString() + " " + this.operator.toQueryString() + " " + this.column.toQueryString();
        }
        return this.column.toQueryString() + " " + this.operator.toQueryString() + " " + this.value.toQueryString();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.column == null ? 0 : this.column.hashCode());
        n = 31 * n + (this.isComparisonOrderReversed ? 1231 : 1237);
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColumnValueFilter columnValueFilter = (ColumnValueFilter)object;
        if (this.column == null ? columnValueFilter.column != null : !this.column.equals(columnValueFilter.column)) {
            return false;
        }
        if (this.isComparisonOrderReversed != columnValueFilter.isComparisonOrderReversed) {
            return false;
        }
        return !(this.value == null ? columnValueFilter.value != null : !this.value.equals(columnValueFilter.value));
    }
}

