/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.text.StrBuilder;

public class CompoundFilter
extends QueryFilter {
    private List<QueryFilter> subFilters;
    private LogicalOperator operator;

    public CompoundFilter(LogicalOperator logicalOperator, List<QueryFilter> list) {
        this.subFilters = list;
        this.operator = logicalOperator;
    }

    @Override
    public boolean isMatch(DataTable dataTable, TableRow tableRow) {
        if (this.subFilters.isEmpty()) {
            throw new RuntimeException("Compound filter with empty subFilters list");
        }
        for (QueryFilter queryFilter : this.subFilters) {
            boolean bl = queryFilter.isMatch(dataTable, tableRow);
            if ((this.operator != LogicalOperator.AND || bl) && (this.operator != LogicalOperator.OR || !bl)) continue;
            return bl;
        }
        return this.operator == LogicalOperator.AND;
    }

    @Override
    public Set<String> getAllColumnIds() {
        HashSet hashSet = Sets.newHashSet();
        for (QueryFilter queryFilter : this.subFilters) {
            hashSet.addAll(queryFilter.getAllColumnIds());
        }
        return hashSet;
    }

    @Override
    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (QueryFilter queryFilter : this.subFilters) {
            arrayList.addAll(queryFilter.getScalarFunctionColumns());
        }
        return arrayList;
    }

    @Override
    protected List<AggregationColumn> getAggregationColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (QueryFilter queryFilter : this.subFilters) {
            arrayList.addAll(queryFilter.getAggregationColumns());
        }
        return arrayList;
    }

    public List<QueryFilter> getSubFilters() {
        return ImmutableList.copyOf(this.subFilters);
    }

    public LogicalOperator getOperator() {
        return this.operator;
    }

    @Override
    public String toQueryString() {
        ArrayList arrayList = Lists.newArrayList();
        for (QueryFilter queryFilter : this.subFilters) {
            arrayList.add("(" + queryFilter.toQueryString() + ")");
        }
        return new StrBuilder().appendWithSeparators((Collection)arrayList, " " + this.operator.name() + " ").toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.operator == null ? 0 : this.operator.hashCode());
        n = 31 * n + (this.subFilters == null ? 0 : ((Object)this.subFilters).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompoundFilter compoundFilter = (CompoundFilter)object;
        if (this.operator == null ? compoundFilter.operator != null : !this.operator.equals((Object)compoundFilter.operator)) {
            return false;
        }
        return !(this.subFilters == null ? compoundFilter.subFilters != null : !((Object)this.subFilters).equals(compoundFilter.subFilters));
    }

    public static enum LogicalOperator {
        AND,
        OR;

    }
}

