/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.util;

import com.google.common.collect.Lists;
import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.ColumnColumnFilter;
import com.google.visualization.datasource.query.ColumnIsNullFilter;
import com.google.visualization.datasource.query.ColumnSort;
import com.google.visualization.datasource.query.ColumnValueFilter;
import com.google.visualization.datasource.query.ComparisonFilter;
import com.google.visualization.datasource.query.CompoundFilter;
import com.google.visualization.datasource.query.NegationFilter;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.QueryGroup;
import com.google.visualization.datasource.query.QuerySelection;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.SimpleColumn;
import com.google.visualization.datasource.query.SortOrder;
import com.google.visualization.datasource.util.SqlDatabaseDescription;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlDataSourceHelper {
    private static final Log log = LogFactory.getLog((String)SqlDataSourceHelper.class.getName());

    private SqlDataSourceHelper() {
    }

    public static DataTable executeQuery(Query query, SqlDatabaseDescription sqlDatabaseDescription) throws DataSourceException {
        Connection connection = SqlDataSourceHelper.getDatabaseConnection(sqlDatabaseDescription);
        String string = sqlDatabaseDescription.getTableName();
        StrBuilder strBuilder = new StrBuilder();
        SqlDataSourceHelper.buildSqlQuery(query, strBuilder, string);
        List<String> list = null;
        if (query.hasSelection()) {
            list = SqlDataSourceHelper.getColumnIdsList(query.getSelection());
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(strBuilder.toString());
            DataTable dataTable = SqlDataSourceHelper.buildColumns(resultSet, list);
            SqlDataSourceHelper.buildRows(dataTable, resultSet);
            DataTable dataTable2 = dataTable;
            return dataTable2;
        }
        catch (SQLException sQLException) {
            String string2 = "Failed to execute SQL query. mySQL error message: " + sQLException.getMessage();
            throw new DataSourceException(ReasonType.INTERNAL_ERROR, string2);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static Connection getDatabaseConnection(SqlDatabaseDescription sqlDatabaseDescription) throws DataSourceException {
        Connection connection;
        String string = sqlDatabaseDescription.getUser();
        String string2 = sqlDatabaseDescription.getPassword();
        String string3 = sqlDatabaseDescription.getUrl();
        try {
            connection = DriverManager.getConnection(string3, string, string2);
        }
        catch (SQLException sQLException) {
            log.error((Object)"Failed to connect to database server.", (Throwable)sQLException);
            throw new DataSourceException(ReasonType.INTERNAL_ERROR, "Failed to connect to database server.");
        }
        return connection;
    }

    private static void buildSqlQuery(Query query, StrBuilder strBuilder, String string) throws DataSourceException {
        SqlDataSourceHelper.appendSelectClause(query, strBuilder);
        SqlDataSourceHelper.appendFromClause(query, strBuilder, string);
        SqlDataSourceHelper.appendWhereClause(query, strBuilder);
        SqlDataSourceHelper.appendGroupByClause(query, strBuilder);
        SqlDataSourceHelper.appendOrderByClause(query, strBuilder);
        SqlDataSourceHelper.appendLimitAndOffsetClause(query, strBuilder);
    }

    static void appendLimitAndOffsetClause(Query query, StrBuilder strBuilder) {
        if (query.hasRowLimit()) {
            strBuilder.append("LIMIT ");
            strBuilder.append(query.getRowLimit());
        }
        if (query.hasRowOffset()) {
            strBuilder.append(" OFFSET ").append(query.getRowOffset());
        }
    }

    static void appendGroupByClause(Query query, StrBuilder strBuilder) {
        if (!query.hasGroup()) {
            return;
        }
        strBuilder.append("GROUP BY ");
        QueryGroup queryGroup = query.getGroup();
        List<String> list = queryGroup.getColumnIds();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : list) {
            arrayList.add('`' + string + '`');
        }
        strBuilder.appendWithSeparators((Collection)arrayList, ", ");
        strBuilder.append(" ");
    }

    static void appendOrderByClause(Query query, StrBuilder strBuilder) {
        if (!query.hasSort()) {
            return;
        }
        strBuilder.append("ORDER BY ");
        QuerySort querySort = query.getSort();
        List<ColumnSort> list = querySort.getSortColumns();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ColumnSort columnSort = list.get(i);
            strBuilder.append(SqlDataSourceHelper.getColumnId(columnSort.getColumn()));
            if (columnSort.getOrder() == SortOrder.DESCENDING) {
                strBuilder.append(" DESC");
            }
            if (i >= n - 1) continue;
            strBuilder.append(", ");
        }
        strBuilder.append(" ");
    }

    static void appendWhereClause(Query query, StrBuilder strBuilder) {
        if (query.hasFilter()) {
            QueryFilter queryFilter = query.getFilter();
            strBuilder.append("WHERE ").append(SqlDataSourceHelper.buildWhereClauseRecursively(queryFilter)).append(" ");
        }
    }

    private static StrBuilder buildWhereClauseRecursively(QueryFilter queryFilter) {
        StrBuilder strBuilder = new StrBuilder();
        if (queryFilter instanceof ColumnIsNullFilter) {
            SqlDataSourceHelper.buildWhereClauseForIsNullFilter(strBuilder, queryFilter);
        } else if (queryFilter instanceof ComparisonFilter) {
            SqlDataSourceHelper.buildWhereCluaseForComparisonFilter(strBuilder, queryFilter);
        } else if (queryFilter instanceof NegationFilter) {
            strBuilder.append("(NOT ");
            strBuilder.append(SqlDataSourceHelper.buildWhereClauseRecursively(((NegationFilter)queryFilter).getSubFilter()));
            strBuilder.append(")");
        } else {
            CompoundFilter compoundFilter = (CompoundFilter)queryFilter;
            int n = compoundFilter.getSubFilters().size();
            if (n == 0) {
                if (compoundFilter.getOperator() == CompoundFilter.LogicalOperator.AND) {
                    strBuilder.append("true");
                } else {
                    strBuilder.append("false");
                }
            } else {
                ArrayList arrayList = Lists.newArrayList();
                for (QueryFilter queryFilter2 : compoundFilter.getSubFilters()) {
                    arrayList.add(SqlDataSourceHelper.buildWhereClauseRecursively(queryFilter2).toString());
                }
                String string = SqlDataSourceHelper.getSqlLogicalOperator(compoundFilter.getOperator());
                strBuilder.append("(").appendWithSeparators((Collection)arrayList, " " + (String)string + " ").append(")");
            }
        }
        return strBuilder;
    }

    private static void buildWhereClauseForIsNullFilter(StrBuilder strBuilder, QueryFilter queryFilter) {
        ColumnIsNullFilter columnIsNullFilter = (ColumnIsNullFilter)queryFilter;
        strBuilder.append("(").append(SqlDataSourceHelper.getColumnId(columnIsNullFilter.getColumn())).append(" IS NULL)");
    }

    private static void buildWhereCluaseForComparisonFilter(StrBuilder strBuilder, QueryFilter queryFilter) {
        StrBuilder strBuilder2 = new StrBuilder();
        StrBuilder strBuilder3 = new StrBuilder();
        if (queryFilter instanceof ColumnColumnFilter) {
            ColumnColumnFilter columnColumnFilter = (ColumnColumnFilter)queryFilter;
            strBuilder2.append(SqlDataSourceHelper.getColumnId(columnColumnFilter.getFirstColumn()));
            strBuilder3.append(SqlDataSourceHelper.getColumnId(columnColumnFilter.getSecondColumn()));
        } else {
            ColumnValueFilter columnValueFilter = (ColumnValueFilter)queryFilter;
            strBuilder2.append(SqlDataSourceHelper.getColumnId(columnValueFilter.getColumn()));
            strBuilder3.append(columnValueFilter.getValue().toString());
            if (columnValueFilter.getValue().getType() == ValueType.TEXT || columnValueFilter.getValue().getType() == ValueType.DATE || columnValueFilter.getValue().getType() == ValueType.DATETIME || columnValueFilter.getValue().getType() == ValueType.TIMEOFDAY) {
                strBuilder3.insert(0, "\"");
                strBuilder3.insert(strBuilder3.length(), "\"");
            }
        }
        strBuilder.append(SqlDataSourceHelper.buildWhereClauseFromRightAndLeftParts(strBuilder2, strBuilder3, ((ComparisonFilter)queryFilter).getOperator()));
    }

    private static String getSqlLogicalOperator(CompoundFilter.LogicalOperator logicalOperator) {
        String string;
        switch (logicalOperator) {
            case AND: {
                string = "AND";
                break;
            }
            case OR: {
                string = "OR";
                break;
            }
            default: {
                throw new RuntimeException("Logical operator was not found: " + (Object)((Object)logicalOperator));
            }
        }
        return string;
    }

    private static StrBuilder buildWhereClauseFromRightAndLeftParts(StrBuilder strBuilder, StrBuilder strBuilder2, ComparisonFilter.Operator operator) {
        StrBuilder strBuilder3;
        switch (operator) {
            case EQ: {
                strBuilder3 = strBuilder.append("=").append(strBuilder2);
                break;
            }
            case NE: {
                strBuilder3 = strBuilder.append("<>").append(strBuilder2);
                break;
            }
            case LT: {
                strBuilder3 = strBuilder.append("<").append(strBuilder2);
                break;
            }
            case GT: {
                strBuilder3 = strBuilder.append(">").append(strBuilder2);
                break;
            }
            case LE: {
                strBuilder3 = strBuilder.append("<=").append(strBuilder2);
                break;
            }
            case GE: {
                strBuilder3 = strBuilder.append(">=").append(strBuilder2);
                break;
            }
            case CONTAINS: {
                strBuilder2 = new StrBuilder(strBuilder2.toString().replace("\"", ""));
                strBuilder3 = strBuilder.append(" LIKE ").append("\"%").append(strBuilder2).append("%\"");
                break;
            }
            case STARTS_WITH: {
                strBuilder2 = new StrBuilder(strBuilder2.toString().replace("\"", ""));
                strBuilder3 = strBuilder.append(" LIKE ").append("\"").append(strBuilder2).append("%\"");
                break;
            }
            case ENDS_WITH: {
                strBuilder2 = new StrBuilder(strBuilder2.toString().replace("\"", ""));
                strBuilder3 = strBuilder.append(" LIKE ").append("\"%").append(strBuilder2).append("\"");
                break;
            }
            case MATCHES: {
                throw new RuntimeException("SQL does not support regular expression");
            }
            case LIKE: {
                strBuilder2 = new StrBuilder(strBuilder2.toString().replace("\"", ""));
                strBuilder3 = strBuilder.append(" LIKE ").append("\"").append(strBuilder2).append("\"");
                break;
            }
            default: {
                throw new RuntimeException("Operator was not found: " + (Object)((Object)operator));
            }
        }
        strBuilder3.insert(0, "(").append(")");
        return strBuilder3;
    }

    static void appendSelectClause(Query query, StrBuilder strBuilder) {
        strBuilder.append("SELECT ");
        if (!query.hasSelection()) {
            strBuilder.append("* ");
            return;
        }
        List<AbstractColumn> list = query.getSelection().getColumns();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            strBuilder.append(SqlDataSourceHelper.getColumnId(list.get(i)));
            if (i >= n - 1) continue;
            strBuilder.append(", ");
        }
        strBuilder.append(" ");
    }

    private static StrBuilder getColumnId(AbstractColumn abstractColumn) {
        StrBuilder strBuilder = new StrBuilder();
        if (abstractColumn instanceof SimpleColumn) {
            strBuilder.append("`").append(abstractColumn.getId()).append("`");
        } else {
            AggregationColumn aggregationColumn = (AggregationColumn)abstractColumn;
            strBuilder.append(SqlDataSourceHelper.getAggregationFunction(aggregationColumn.getAggregationType())).append("(`").append((Object)aggregationColumn.getAggregatedColumn()).append("`)");
        }
        return strBuilder;
    }

    private static List<String> getColumnIdsList(QuerySelection querySelection) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)querySelection.getColumns().size());
        for (AbstractColumn abstractColumn : querySelection.getColumns()) {
            arrayList.add(abstractColumn.getId());
        }
        return arrayList;
    }

    private static String getAggregationFunction(AggregationType aggregationType) {
        return aggregationType.getCode();
    }

    static void appendFromClause(Query query, StrBuilder strBuilder, String string) throws DataSourceException {
        if (StringUtils.isEmpty((String)string)) {
            log.error((Object)"No table name provided.");
            throw new DataSourceException(ReasonType.OTHER, "No table name provided.");
        }
        strBuilder.append("FROM ");
        strBuilder.append(string);
        strBuilder.append(" ");
    }

    static DataTable buildColumns(ResultSet resultSet, List<String> list) throws SQLException {
        DataTable dataTable = new DataTable();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String string = list == null ? resultSetMetaData.getColumnLabel(i) : list.get(i - 1);
            ColumnDescription columnDescription = new ColumnDescription(string, SqlDataSourceHelper.sqlTypeToValueType(resultSetMetaData.getColumnType(i)), resultSetMetaData.getColumnLabel(i));
            dataTable.addColumn(columnDescription);
        }
        return dataTable;
    }

    private static ValueType sqlTypeToValueType(int n) {
        ValueType valueType;
        switch (n) {
            case -7: 
            case 16: {
                valueType = ValueType.BOOLEAN;
                break;
            }
            case 1: 
            case 12: {
                valueType = ValueType.TEXT;
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                valueType = ValueType.NUMBER;
                break;
            }
            case 91: {
                valueType = ValueType.DATE;
                break;
            }
            case 92: {
                valueType = ValueType.TIMEOFDAY;
                break;
            }
            case 93: {
                valueType = ValueType.DATETIME;
                break;
            }
            default: {
                valueType = ValueType.TEXT;
            }
        }
        return valueType;
    }

    static void buildRows(DataTable dataTable, ResultSet resultSet) throws SQLException {
        List<ColumnDescription> list = dataTable.getColumnDescriptions();
        int n = dataTable.getNumberOfColumns();
        ValueType[] valueTypeArray = new ValueType[n];
        for (int i = 0; i < n; ++i) {
            valueTypeArray[i] = list.get(i).getType();
        }
        while (resultSet.next()) {
            TableRow tableRow = new TableRow();
            for (int i = 0; i < n; ++i) {
                tableRow.addCell(SqlDataSourceHelper.buildTableCell(resultSet, valueTypeArray[i], i));
            }
            try {
                dataTable.addRow(tableRow);
            }
            catch (TypeMismatchException typeMismatchException) {}
        }
    }

    private static TableCell buildTableCell(ResultSet resultSet, ValueType valueType, int n) throws SQLException {
        Value value = null;
        ++n;
        switch (valueType) {
            case BOOLEAN: {
                value = BooleanValue.getInstance(resultSet.getBoolean(n));
                break;
            }
            case NUMBER: {
                value = new NumberValue(resultSet.getDouble(n));
                break;
            }
            case DATE: {
                Date date = resultSet.getDate(n);
                if (date == null) break;
                GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
                gregorianCalendar.set(date.getYear() + 1900, date.getMonth(), date.getDate());
                value = new DateValue(gregorianCalendar);
                break;
            }
            case DATETIME: {
                Timestamp timestamp = resultSet.getTimestamp(n);
                if (timestamp == null) break;
                GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
                gregorianCalendar.set(timestamp.getYear() + 1900, timestamp.getMonth(), timestamp.getDate(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
                gregorianCalendar.set(14, timestamp.getNanos() / 1000000);
                value = new DateTimeValue(gregorianCalendar);
                break;
            }
            case TIMEOFDAY: {
                Time time = resultSet.getTime(n);
                if (time == null) break;
                GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"GMT"));
                gregorianCalendar.set(1970, 0, 1, time.getHours(), time.getMinutes(), time.getSeconds());
                gregorianCalendar.set(14, 0);
                value = new TimeOfDayValue(gregorianCalendar);
                break;
            }
            default: {
                String string = resultSet.getString(n);
                value = string == null ? TextValue.getNullValue() : new TextValue(resultSet.getString(n));
            }
        }
        if (resultSet.wasNull()) {
            return new TableCell(Value.getNullValueFromValueType(valueType));
        }
        return new TableCell(value);
    }
}

