/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *              C E D A R
 *          S O L U T I O N S       "Software done right."
 *           S O F T W A R E
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Copyright (c) 2013 Kenneth J. Pronovici.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Apache License, Version 2.0.
 * See LICENSE for more information about the licensing terms.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Author   : Kenneth J. Pronovici <pronovic@ieee.org>
 * Language : Java 6
 * Project  : Common Java Functionality
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
package com.cedarsolutions.shared.domain;

import com.flipthebird.gwthashcodeequals.EqualsBuilder;
import com.flipthebird.gwthashcodeequals.HashCodeBuilder;

/**
 * Federated user, as returned from services.
 *
 * <p>
 * For our purposes, federated users are users identified by an OpenId provider
 * like Google or AOL.  Federated users have more attributes than simple Google
 * users.  We track the authentication domain, derive a legible user name, etc.
 * </p>
 *
 * @author Kenneth J. Pronovici <pronovic@ieee.org>
 */
public class FederatedUser extends TranslatableDomainObject {

    /** Serialization version number, which can be important to the GAE back-end. */
    private static final long serialVersionUID = 1L;

    /** Unique user identifier across all authentication domains. */
    private String userId;

    /** Legible username for display purposes (format varies by provider). */
    private String userName;

    /** Email address associated with a login (only available for some providers). */
    private String emailAddress;

    /** Authentication domain for this login. */
    private String authenticationDomain;

    /** Open id provider (usually tied to the authentication domain). */
    private OpenIdProvider openIdProvider;

    /** Federated identity (generated by the OpenId provider). */
    private String federatedIdentity;

    /** Whether this user is an administrator. */
    private boolean admin;

    /** Whether this is the user's first login. */
    private boolean firstLogin;

    /** Compare this object to another object. */
    @Override
    public boolean equals(Object obj) {
        FederatedUser other = (FederatedUser) obj;
        return new EqualsBuilder()
                    .append(this.userId, other.userId)
                    .append(this.userName, other.userName)
                    .append(this.emailAddress, other.emailAddress)
                    .append(this.authenticationDomain, other.authenticationDomain)
                    .append(this.openIdProvider, other.openIdProvider)
                    .append(this.federatedIdentity, other.federatedIdentity)
                    .append(this.admin, other.admin)
                    .append(this.firstLogin, other.firstLogin)
                    .isEquals();
    }

    /** Generate a hash code for this object. */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                    .append(this.userId)
                    .append(this.userName)
                    .append(this.emailAddress)
                    .append(this.authenticationDomain)
                    .append(this.openIdProvider)
                    .append(this.federatedIdentity)
                    .append(this.admin)
                    .append(this.firstLogin)
                    .toHashCode();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getAuthenticationDomain() {
        return this.authenticationDomain;
    }

    public void setAuthenticationDomain(String authenticationDomain) {
        this.authenticationDomain = authenticationDomain;
    }

    public OpenIdProvider getOpenIdProvider() {
        return this.openIdProvider;
    }

    public void setOpenIdProvider(OpenIdProvider openIdProvider) {
        this.openIdProvider = openIdProvider;
    }

    public String getFederatedIdentity() {
        return this.federatedIdentity;
    }

    public void setFederatedIdentity(String federatedIdentity) {
        this.federatedIdentity = federatedIdentity;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isFirstLogin() {
        return this.firstLogin;
    }

    public void setFirstLogin(boolean firstLogin) {
        this.firstLogin = firstLogin;
    }

}
