/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class GetBinariesMojo
extends AbstractMojo {
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String classifier;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String version;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private MavenProject project;
    private final boolean isPosix = !System.getProperty("os.name").toLowerCase().startsWith("windows");

    @SuppressWarnings(value={"NP_UNWRITTEN_FIELD"})
    public void execute() throws MojoExecutionException {
        String suffix;
        switch (this.classifier) {
            case "windows": {
                suffix = "win32-x86.zip";
                break;
            }
            case "linux": {
                suffix = "Linux-i386.tar.gz";
                break;
            }
            case "mac": {
                suffix = "Darwin64-universal.tar.gz";
                break;
            }
            default: {
                throw new MojoExecutionException("Unsupported classifier: " + this.classifier);
            }
        }
        String cmakeVersion = this.getCMakeVersion(this.version);
        Path target = Paths.get(this.project.getBuild().getDirectory(), "dependency/cmake");
        try {
            String majorVersion = this.getMajorVersion(cmakeVersion);
            Path result = this.download(new URL("http://www.cmake.org/files/v" + majorVersion + "/cmake-" + cmakeVersion + "-" + suffix));
            if (Files.notExists(target.resolve("bin"), new LinkOption[0])) {
                this.extract(result, target);
                this.normalizeDirectories(target);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private String getCMakeVersion(String version) {
        Preconditions.checkNotNull((Object)version, (Object)"version may not be null");
        Preconditions.checkArgument((!version.isEmpty() ? 1 : 0) != 0, (Object)"version may not be empty");
        Pattern pattern = Pattern.compile("^(.*?)-.*");
        Matcher matcher = pattern.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Unexpected version format: " + version);
        }
        return matcher.group(1);
    }

    private String getMajorVersion(String version) {
        Preconditions.checkNotNull((Object)version, (Object)"version may not be null");
        Preconditions.checkArgument((!version.isEmpty() ? 1 : 0) != 0, (Object)"version may not be empty");
        Pattern pattern = Pattern.compile("^[\\d]*\\.[\\d]*");
        Matcher matcher = pattern.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Unexpected version format: " + version);
        }
        return matcher.group();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path download(URL url) throws MojoExecutionException {
        String filename = new File(url.getPath()).getName();
        Path result = Paths.get(this.project.getBuild().getDirectory(), filename);
        try {
            if (Files.notExists(result, new LinkOption[0])) {
                Log log = this.getLog();
                if (log.isInfoEnabled()) {
                    log.info((CharSequence)("Downloading: " + url.toString()));
                }
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                try {
                    BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                    Files.createDirectories(Paths.get(this.project.getBuild().getDirectory(), new String[0]), new FileAttribute[0]);
                    BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(result, new OpenOption[0]));
                    byte[] buffer = new byte[10240];
                    try {
                        int count;
                        while ((count = in.read(buffer)) != -1) {
                            out.write(buffer, 0, count);
                        }
                    }
                    finally {
                        in.close();
                        out.close();
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private void extract(Path source, Path target) throws IOException {
        Files.createDirectories(target, new FileAttribute[0]);
        String filename = source.getFileName().toString();
        String extension = this.getFileExtension(filename);
        String nameWithoutExtension = filename.substring(0, filename.length() - extension.length());
        String nextExtension = this.getFileExtension(nameWithoutExtension);
        switch (extension) {
            case ".jar": 
            case ".zip": {
                if (!nextExtension.isEmpty()) {
                    throw new UnsupportedOperationException("Unsupported file type: " + source);
                }
                this.extractZip(source, target);
                break;
            }
            case ".gz": {
                if (!nextExtension.isEmpty()) {
                    Path outputDir = Files.createTempDirectory("cmake", new FileAttribute[0]);
                    Path result = this.extractGzip(source, outputDir);
                    this.extract(result, target);
                    Files.deleteIfExists(result);
                    Files.deleteIfExists(outputDir);
                    break;
                }
                this.extractGzip(source, target);
                break;
            }
            case ".tar": {
                if (!nextExtension.isEmpty()) {
                    throw new UnsupportedOperationException("Unsupported file type: " + source);
                }
                this.extractTar(source, target);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported file type: " + source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractZip(Path source, Path target) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        try (ZipFile zipFile = new ZipFile(source.toFile());){
            Enumeration entries = zipFile.getEntriesInPhysicalOrder();
            block21: while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                ArrayList<FileAttribute<Set<PosixFilePermission>>> attributes = new ArrayList<FileAttribute<Set<PosixFilePermission>>>();
                if (this.isPosix) {
                    attributes.add(PosixFilePermissions.asFileAttribute(this.getPosixPermissions(entry.getUnixMode())));
                }
                if (entry.isDirectory()) {
                    Path directory = target.resolve(entry.getName());
                    Files.createDirectories(directory, new FileAttribute[0]);
                    if (!this.isPosix) continue;
                    Files.setPosixFilePermissions(directory, (Set)((FileAttribute)attributes.get(0)).value());
                    continue;
                }
                ReadableByteChannel reader = Channels.newChannel(zipFile.getInputStream(entry));
                Throwable throwable = null;
                try {
                    Path targetFile = target.resolve(entry.getName());
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    SeekableByteChannel out = Files.newByteChannel(targetFile, (Set<? extends OpenOption>)ImmutableSet.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.TRUNCATE_EXISTING, (Object)StandardOpenOption.WRITE), attributes.toArray(new FileAttribute[0]));
                    Throwable throwable2 = null;
                    try {
                        int count;
                        for (long bytesLeft = entry.getSize(); bytesLeft > 0L; bytesLeft -= (long)count) {
                            if (bytesLeft < (long)buffer.limit()) {
                                buffer.limit((int)bytesLeft);
                            }
                            if ((count = reader.read(buffer)) == -1) continue block21;
                            buffer.flip();
                            do {
                                out.write(buffer);
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractTar(Path source, Path target) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        try (TarArchiveInputStream in = new TarArchiveInputStream(Files.newInputStream(source, new OpenOption[0]));){
            while (true) {
                SeekableByteChannel out;
                block28: {
                    TarArchiveEntry entry;
                    if ((entry = in.getNextTarEntry()) == null) {
                        return;
                    }
                    ArrayList<FileAttribute<Set<PosixFilePermission>>> attributes = new ArrayList<FileAttribute<Set<PosixFilePermission>>>();
                    if (this.isPosix) {
                        attributes.add(PosixFilePermissions.asFileAttribute(this.getPosixPermissions(entry.getMode())));
                    }
                    if (entry.isDirectory()) {
                        Path directory = target.resolve(entry.getName());
                        Files.createDirectories(directory, new FileAttribute[0]);
                        if (!this.isPosix) continue;
                        Files.setPosixFilePermissions(directory, (Set)((FileAttribute)attributes.get(0)).value());
                        continue;
                    }
                    ReadableByteChannel reader = Channels.newChannel((InputStream)in);
                    Path targetFile = target.resolve(entry.getName());
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    out = Files.newByteChannel(targetFile, (Set<? extends OpenOption>)ImmutableSet.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.TRUNCATE_EXISTING, (Object)StandardOpenOption.WRITE), attributes.toArray(new FileAttribute[0]));
                    Throwable throwable = null;
                    try {
                        int count;
                        for (long bytesLeft = entry.getSize(); bytesLeft > 0L; bytesLeft -= (long)count) {
                            if (bytesLeft < (long)buffer.limit()) {
                                buffer.limit((int)bytesLeft);
                            }
                            if ((count = reader.read(buffer)) == -1) break;
                            buffer.flip();
                            do {
                                out.write(buffer);
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        if (out == null) continue;
                        if (throwable == null) break block28;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    out.close();
                                    throw throwable3;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                            }
                            out.close();
                            throw throwable3;
                        }
                    }
                    try {
                        out.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private Set<PosixFilePermission> getPosixPermissions(int mode) {
        StringBuilder result = new StringBuilder(9);
        for (int i = 3; i >= 1; --i) {
            int digit = (int)((double)(mode = (int)((double)mode % Math.pow(8.0, i))) / Math.pow(8.0, i - 1));
            if ((digit & 4) != 0) {
                result.append("r");
            } else {
                result.append("-");
            }
            if ((digit & 2) != 0) {
                result.append("w");
            } else {
                result.append("-");
            }
            if ((digit & 1) != 0) {
                result.append("x");
                continue;
            }
            result.append("-");
        }
        return PosixFilePermissions.fromString(result.toString());
    }

    private Path extractGzip(Path source, Path target) throws IOException {
        String filename = source.getFileName().toString();
        String extension = this.getFileExtension(filename);
        String nameWithoutExtension = filename.substring(0, filename.length() - extension.length());
        Path outPath = target.resolve(nameWithoutExtension);
        try (GzipCompressorInputStream in = new GzipCompressorInputStream(Files.newInputStream(source, new OpenOption[0]));
             OutputStream out = Files.newOutputStream(outPath, new OpenOption[0]);){
            int count;
            byte[] buffer = new byte[10240];
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
        }
        return outPath;
    }

    private String getFileExtension(String filename) {
        Preconditions.checkNotNull((Object)filename, (Object)"filename may not be null");
        Pattern pattern = Pattern.compile("[^\\.]+(\\.[\\p{Alnum}]+)$");
        Matcher matcher = pattern.matcher(filename);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private void normalizeDirectories(final Path source) throws IOException {
        final Path[] topDirectory = new Path[1];
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.getFileName().toString().equals("bin")) {
                    topDirectory[0] = dir.getParent().toAbsolutePath();
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (topDirectory[0] == null) {
            throw new IOException("Could not find \"bin\" in: " + source);
        }
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (topDirectory[0].startsWith(file.getParent())) {
                    return FileVisitResult.CONTINUE;
                }
                Files.move(file, source.resolve(topDirectory[0].relativize(file)), StandardCopyOption.ATOMIC_MOVE);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (topDirectory[0].startsWith(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                Files.move(dir, source.resolve(topDirectory[0].relativize(dir)), StandardCopyOption.ATOMIC_MOVE);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        this.deleteRecursively(topDirectory[0]);
    }

    private void deleteRecursively(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException t) throws IOException {
                if (t == null) {
                    Files.deleteIfExists(dir);
                }
                return super.postVisitDirectory(dir, t);
            }
        });
    }
}

