/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="get-binaries", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GetBinariesMojo
extends AbstractMojo {
    private static final int MAX_RETRIES = 30;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter(property="classifier", readonly=true)
    private String classifier;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter(property="project.version")
    private String projectVersion;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"})
    public void execute() throws MojoExecutionException {
        String suffix;
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping plugin because <skip> was true");
            return;
        }
        if (this.classifier == null || this.classifier.trim().isEmpty()) {
            throw new MojoExecutionException("classifier must be specified");
        }
        switch (this.classifier) {
            case "windows-i386": {
                suffix = "win32-x86.zip";
                break;
            }
            case "windows-amd64": {
                suffix = "win64-x64.zip";
                break;
            }
            case "linux-amd64": {
                suffix = "Linux-x86_64.tar.gz";
                break;
            }
            case "mac-amd64": {
                suffix = "Darwin-x86_64.tar.gz";
                break;
            }
            default: {
                throw new MojoExecutionException("Unsupported classifier: " + this.classifier);
            }
        }
        String cmakeVersion = this.getCMakeVersion(this.projectVersion);
        Path target = Paths.get(this.project.getBuild().getDirectory(), "dependency/cmake");
        try {
            String majorVersion = this.getMajorVersion(cmakeVersion);
            Path archive = this.download(new URL("https://cmake.org/files/v" + majorVersion + "/cmake-" + cmakeVersion + "-" + suffix));
            if (Files.notExists(target.resolve("bin"), new LinkOption[0])) {
                this.deleteRecursively(target);
                Log log = this.getLog();
                if (log.isInfoEnabled()) {
                    log.info((CharSequence)("Extracting " + archive + " to " + target));
                }
                this.extract(archive, target);
                this.normalizeDirectories(target);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private String getCMakeVersion(String version) {
        Preconditions.checkNotNull((Object)version, (Object)"version may not be null");
        Preconditions.checkArgument((!version.isEmpty() ? 1 : 0) != 0, (Object)"version may not be empty");
        Pattern pattern = Pattern.compile("^(.*?)-.+");
        Matcher matcher = pattern.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Unexpected version format: " + version);
        }
        return matcher.group(1);
    }

    private String getMajorVersion(String version) {
        Preconditions.checkNotNull((Object)version, (Object)"version may not be null");
        Preconditions.checkArgument((!version.isEmpty() ? 1 : 0) != 0, (Object)"version may not be empty");
        Pattern pattern = Pattern.compile("^[\\d]*\\.[\\d]*");
        Matcher matcher = pattern.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Unexpected version format: " + version);
        }
        return matcher.group();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path download(URL url) throws MojoExecutionException {
        String filename = new File(url.getPath()).getName();
        Path result = Paths.get(this.project.getBuild().getDirectory(), filename);
        try {
            if (Files.notExists(result, new LinkOption[0])) {
                Log log = this.getLog();
                if (log.isInfoEnabled()) {
                    log.info((CharSequence)("Downloading: " + url.toString()));
                }
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());){
                    Files.createDirectories(Paths.get(this.project.getBuild().getDirectory(), new String[0]), new FileAttribute[0]);
                    try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(result, new OpenOption[0]));){
                        int count;
                        byte[] buffer = new byte[10240];
                        while ((count = in.read(buffer)) != -1) {
                            out.write(buffer, 0, count);
                        }
                    }
                }
                finally {
                    connection.disconnect();
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private void extract(Path source, Path target) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        try {
            this.extractCompressor(source, target, buffer);
        }
        catch (IOException e) {
            if (!(e.getCause() instanceof CompressorException)) {
                throw e;
            }
            this.extractArchive(source, target, buffer);
        }
    }

    private void extractArchive(Path source, Path target, ByteBuffer buffer) throws IOException {
        Path tempDir = Files.createTempDirectory("cmake", new FileAttribute[0]);
        try (ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(source, new OpenOption[0])));){
            ArchiveEntry entry;
            FileAttribute[] attributes = this.supportsPosix((InputStream)in) ? new FileAttribute[1] : new FileAttribute[]{};
            while ((entry = in.getNextEntry()) != null) {
                if (!in.canReadEntryData(entry)) {
                    long actual;
                    this.getLog().warn((CharSequence)("Unsupported entry type for " + entry.getName() + ", skipping..."));
                    for (long remaining = entry.getSize(); remaining > 0L; remaining -= actual) {
                        actual = in.skip(entry.getSize());
                        if (actual <= 0L) {
                            throw new AssertionError((Object)("skip() returned " + actual));
                        }
                    }
                    continue;
                }
                if (attributes.length > 0) {
                    attributes[0] = PosixFilePermissions.asFileAttribute(this.getPosixPermissions(entry));
                }
                if (entry.isDirectory()) {
                    Path directory = tempDir.resolve(entry.getName());
                    Files.createDirectories(directory, new FileAttribute[0]);
                    if (attributes.length <= 0) continue;
                    Set permissions = (Set)attributes[0].value();
                    Files.setPosixFilePermissions(directory, permissions);
                    continue;
                }
                ReadableByteChannel reader = Channels.newChannel((InputStream)in);
                Path targetFile = tempDir.resolve(entry.getName());
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                SeekableByteChannel out = Files.newByteChannel(targetFile, (Set<? extends OpenOption>)ImmutableSet.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.TRUNCATE_EXISTING, (Object)StandardOpenOption.WRITE), attributes);
                Throwable throwable = null;
                try {
                    int count;
                    while ((count = reader.read(buffer)) != -1) {
                        buffer.flip();
                        do {
                            out.write(buffer);
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            this.copyDirectory(tempDir, target);
            this.deleteRecursively(tempDir);
        }
        catch (ArchiveException e) {
            throw new IOException("Could not uncompress: " + source, e);
        }
    }

    private void copyDirectory(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(target.resolve(source.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                throw e;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e != null) {
                    throw e;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void extractCompressor(Path source, Path target, ByteBuffer buffer) throws IOException {
        String filename = source.getFileName().toString();
        String extension = this.getFileExtension(filename);
        String nameWithoutExtension = filename.substring(0, filename.length() - extension.length());
        String nextExtension = this.getFileExtension(nameWithoutExtension);
        try (CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(source, new OpenOption[0])));){
            Path tempDir = Files.createTempDirectory("cmake", new FileAttribute[0]);
            ReadableByteChannel reader = Channels.newChannel((InputStream)in);
            Path intermediateTarget = tempDir.resolve(nameWithoutExtension);
            try (SeekableByteChannel out = Files.newByteChannel(intermediateTarget, (Set<? extends OpenOption>)ImmutableSet.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.TRUNCATE_EXISTING, (Object)StandardOpenOption.WRITE), new FileAttribute[0]);){
                int count;
                while ((count = reader.read(buffer)) != -1) {
                    buffer.flip();
                    do {
                        out.write(buffer);
                    } while (buffer.hasRemaining());
                    buffer.clear();
                }
            }
            if (!nextExtension.isEmpty()) {
                this.extract(intermediateTarget, target);
                this.deleteRecursively(tempDir);
            } else {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.move(tempDir, target, new CopyOption[0]);
            }
        }
        catch (CompressorException e) {
            throw new IOException("Could not uncompress: " + source, e);
        }
    }

    private boolean supportsPosix(InputStream in) {
        return !System.getProperty("os.name").toLowerCase(Locale.US).startsWith("windows") && (in instanceof ArchiveInputStream || in instanceof ZipArchiveInputStream || in instanceof TarArchiveInputStream);
    }

    private Set<PosixFilePermission> getPosixPermissions(ArchiveEntry entry) {
        int mode;
        if (entry instanceof ArArchiveEntry) {
            ArArchiveEntry arEntry = (ArArchiveEntry)entry;
            mode = arEntry.getMode();
        } else if (entry instanceof ZipArchiveEntry) {
            ZipArchiveEntry zipEntry = (ZipArchiveEntry)entry;
            mode = zipEntry.getUnixMode();
        } else if (entry instanceof TarArchiveEntry) {
            TarArchiveEntry tarEntry = (TarArchiveEntry)entry;
            mode = tarEntry.getMode();
        } else {
            throw new IllegalArgumentException(entry.getClass().getName() + " does not support POSIX permissions");
        }
        StringBuilder result = new StringBuilder(9);
        for (int i = 3; i >= 1; --i) {
            int digit = (int)((double)(mode = (int)((double)mode % Math.pow(8.0, i))) / Math.pow(8.0, i - 1));
            if ((digit & 4) != 0) {
                result.append("r");
            } else {
                result.append("-");
            }
            if ((digit & 2) != 0) {
                result.append("w");
            } else {
                result.append("-");
            }
            if ((digit & 1) != 0) {
                result.append("x");
                continue;
            }
            result.append("-");
        }
        return PosixFilePermissions.fromString(result.toString());
    }

    private String getFileExtension(String filename) {
        Preconditions.checkNotNull((Object)filename, (Object)"filename may not be null");
        Pattern pattern = Pattern.compile("[^\\.]+(\\.[\\p{Alnum}]+)$");
        Matcher matcher = pattern.matcher(filename);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private void normalizeDirectories(final Path source) throws IOException {
        final Path[] topDirectory = new Path[1];
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.getFileName().toString().equals("bin")) {
                    topDirectory[0] = dir.getParent().toAbsolutePath();
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (topDirectory[0] == null) {
            throw new IOException("Could not find \"bin\" in: " + source);
        }
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (topDirectory[0].startsWith(file.getParent())) {
                    return FileVisitResult.CONTINUE;
                }
                Files.move(file, source.resolve(topDirectory[0].relativize(file)), StandardCopyOption.ATOMIC_MOVE);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (topDirectory[0].startsWith(dir)) {
                    return FileVisitResult.CONTINUE;
                }
                Files.move(dir, source.resolve(topDirectory[0].relativize(dir)), StandardCopyOption.ATOMIC_MOVE);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        this.deleteRecursively(topDirectory[0]);
    }

    private void deleteRecursively(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException t) throws IOException {
                if (t == null) {
                    int i = 0;
                    while (true) {
                        try {
                            Files.deleteIfExists(dir);
                        }
                        catch (DirectoryNotEmptyException e) {
                            block8: {
                                if (i < 30) {
                                    long timeout = Math.min(1000L, (long)(10.0 * Math.pow(2.0, i)));
                                    try {
                                        Log log = GetBinariesMojo.this.getLog();
                                        if (log.isInfoEnabled()) {
                                            log.info((CharSequence)(dir + " is locked... Sleeping before retry [" + (i + 1) + "/" + 30 + "]"));
                                        }
                                        TimeUnit.MILLISECONDS.sleep(timeout);
                                        break block8;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                throw e;
                            }
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                return super.postVisitDirectory(dir, t);
            }
        });
    }
}

