/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.bitbucket.cowwoc.pouch.ConcurrentLazyReference;
import org.bitbucket.cowwoc.pouch.Reference;

public final class OperatingSystem {
    private static final Reference<OperatingSystem> DETECTED = ConcurrentLazyReference.create(() -> {
        Type type = Type.detected();
        Architecture architecture = Architecture.detected();
        return new OperatingSystem(type, architecture);
    });
    public final Type type;
    public final Architecture architecture;

    public static OperatingSystem detected() {
        return (OperatingSystem)DETECTED.getValue();
    }

    public String getClassifier() {
        switch (this.type) {
            case LINUX: {
                switch (this.architecture) {
                    case X86_32: {
                        return "linux-arm_32";
                    }
                    case X86_64: {
                        return "linux-x86_64";
                    }
                }
                throw new UnsupportedOperationException("Unsupported architecture: " + this.architecture);
            }
            case MAC: {
                switch (this.architecture) {
                    case X86_64: 
                    case ARM_64: {
                        return "mac-universal";
                    }
                }
                throw new UnsupportedOperationException("Unsupported architecture: " + this.architecture);
            }
            case WINDOWS: {
                if (this.architecture == Architecture.X86_64) {
                    return "windows-x86_64";
                }
                throw new UnsupportedOperationException("Unsupported architecture: " + this.architecture);
            }
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + this.type);
    }

    public Path getExecutableOnPath(String filename, String path) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("filename may not be null");
        }
        if (path == null) {
            throw new NullPointerException("path may not be null");
        }
        String suffix = this.getExecutableSuffix();
        for (String dirname : path.split(File.pathSeparator)) {
            Path result;
            if ((dirname = dirname.trim()).length() >= 2 && dirname.startsWith("\"") && dirname.endsWith("\"") || dirname.startsWith("'") && dirname.endsWith("'")) {
                dirname = dirname.substring(1, dirname.length() - 1);
            }
            if (!Files.isRegularFile(result = Paths.get(dirname, filename + suffix), new LinkOption[0]) || !Files.isExecutable(result)) continue;
            return result;
        }
        throw new FileNotFoundException(filename + " not found on PATH: " + path);
    }

    public String getExecutableSuffix() {
        switch (this.type) {
            case LINUX: 
            case MAC: {
                return "";
            }
            case WINDOWS: {
                return ".exe";
            }
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + this.type);
    }

    public String getDownloadSuffix() {
        switch (this.type) {
            case LINUX: {
                if (this.architecture == Architecture.X86_64) {
                    return "linux-x86_64.tar.gz";
                }
                throw new UnsupportedOperationException("Unsupported architecture: " + this.architecture);
            }
            case MAC: {
                switch (this.architecture) {
                    case X86_64: 
                    case ARM_64: {
                        return "macos-universal.tar.gz";
                    }
                }
                throw new UnsupportedOperationException("Unsupported architecture: " + this.architecture);
            }
            case WINDOWS: {
                if (this.architecture == Architecture.X86_64) {
                    return "windows-x86_64.zip";
                }
                throw new UnsupportedOperationException("Unsupported architecture: " + this.architecture);
            }
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + this.type);
    }

    public boolean supportsPosix(InputStream in) {
        switch (this.type) {
            case LINUX: 
            case MAC: {
                return in instanceof ArchiveInputStream;
            }
            case WINDOWS: {
                return false;
            }
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + this.type);
    }

    public String getEnvironment(ProcessBuilder processBuilder, String name) {
        Map<String, String> environment = processBuilder.environment();
        return environment.get(this.type.getEnvironmentCanonicalName(environment, name));
    }

    public void overrideEnvironmentVariables(Map<String, String> source, ProcessBuilder target) {
        assert (source != null);
        assert (target != null);
        if (source.isEmpty()) {
            return;
        }
        Map<String, String> environment = target.environment();
        for (Map.Entry<String, String> entry : source.entrySet()) {
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            String name = entry.getKey();
            name = this.type.getEnvironmentCanonicalName(environment, name);
            environment.put(name, value);
        }
    }

    OperatingSystem(Type type, Architecture architecture) {
        assert (type != null) : "type may not be null";
        assert (architecture != null) : "architecture may not be null";
        this.type = type;
        this.architecture = architecture;
    }

    public String toString() {
        return this.type + " " + this.architecture;
    }

    public static enum Type {
        WINDOWS{

            @Override
            String getEnvironmentCanonicalName(Map<String, String> environment, String name) {
                for (String canonicalName : environment.keySet()) {
                    if (!canonicalName.equalsIgnoreCase(name)) continue;
                    return canonicalName;
                }
                return name;
            }
        }
        ,
        LINUX{

            @Override
            String getEnvironmentCanonicalName(Map<String, String> environment, String name) {
                return name;
            }
        }
        ,
        MAC{

            @Override
            String getEnvironmentCanonicalName(Map<String, String> environment, String name) {
                return name;
            }
        };

        private static final Reference<Type> DETECTED;

        public static Type detected() {
            return (Type)((Object)DETECTED.getValue());
        }

        private static boolean startsWithIgnoreCase(String str, String prefix) {
            return str.regionMatches(true, 0, prefix, 0, prefix.length());
        }

        abstract String getEnvironmentCanonicalName(Map<String, String> var1, String var2);

        static {
            DETECTED = ConcurrentLazyReference.create(() -> {
                String osName = System.getProperty("os.name");
                if (Type.startsWithIgnoreCase(osName, "windows")) {
                    return WINDOWS;
                }
                if (Type.startsWithIgnoreCase(osName, "linux")) {
                    return LINUX;
                }
                if (Type.startsWithIgnoreCase(osName, "mac")) {
                    return MAC;
                }
                throw new AssertionError((Object)("Unsupported operating system: " + osName + "\nproperties: " + System.getProperties()));
            });
        }
    }

    public static enum Architecture {
        X86_32,
        X86_64,
        ARM_64;

        private static final Reference<Architecture> DETECTED;

        public static Architecture detected() {
            return (Architecture)((Object)DETECTED.getValue());
        }

        static {
            DETECTED = ConcurrentLazyReference.create(() -> {
                String osArch = System.getProperty("os.arch");
                switch (osArch = osArch.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "")) {
                    case "x8632": 
                    case "x86": 
                    case "i386": 
                    case "i486": 
                    case "i586": 
                    case "i686": 
                    case "ia32": 
                    case "x32": {
                        return X86_32;
                    }
                    case "x8664": 
                    case "amd64": 
                    case "ia32e": 
                    case "em64t": 
                    case "x64": {
                        return X86_64;
                    }
                    case "aarch64": {
                        return ARM_64;
                    }
                }
                throw new AssertionError((Object)("Unsupported architecture: " + osArch + "\nproperties: " + System.getProperties()));
            });
        }
    }
}

