/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.googlecode.cmakemavenproject.Compiler;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class CompileMojo
extends AbstractMojo {
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String buildType;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String generator;
    private String platform;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private File projectPath;

    private static String getPlatformFromGenerator(String generator) {
        if (generator.contains("Win64")) {
            return "x64";
        }
        return "Win32";
    }

    @SuppressWarnings(value={"NP_UNWRITTEN_FIELD"})
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Compiler compiler = Compiler.fromGenerator(this.generator, this.getLog());
            if (compiler == null) {
                throw new MojoExecutionException("Cannot find generator: " + this.generator);
            }
            if (!this.projectPath.exists()) {
                throw new MojoExecutionException(this.projectPath.getAbsolutePath() + " does not exist");
            }
            if (this.platform == null) {
                this.platform = CompileMojo.getPlatformFromGenerator(this.generator);
            }
            if (!compiler.compile(this.projectPath, this.platform, this.buildType)) {
                throw new MojoFailureException("Compilation failed");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("", e);
        }
    }
}

