/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.googlecode.cmakemavenproject.GccCompiler;
import com.googlecode.cmakemavenproject.VisualStudioCompiler;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;

public abstract class Compiler {
    private final Type type;
    private final Log log;

    protected Compiler(Type type, Log log) {
        this.type = type;
        this.log = log;
    }

    public static Compiler fromGenerator(String name, Log log) {
        Compiler result = VisualStudioCompiler.fromGenerator(name, log);
        if (result != null) {
            return result;
        }
        result = GccCompiler.fromGenerator(name, log);
        if (result != null) {
            return result;
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    protected Log getLog() {
        return this.log;
    }

    public abstract boolean compile(File var1, String var2, String var3) throws IOException, InterruptedException;

    public static enum Type {
        BORLAND,
        MSYS,
        MINGW,
        NMAKE,
        JOM,
        GNU_MAKE,
        VISUAL_STUDIO,
        WATCOM,
        CODE_BLOCKS,
        ECLIPSE;

    }
}

