/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.google.common.collect.Lists;
import com.googlecode.cmakemavenproject.Compiler;
import com.googlecode.cmakemavenproject.Mojos;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;

public final class GccCompiler
extends Compiler {
    public GccCompiler(Log log) {
        super(Compiler.Type.GNU_MAKE, log);
    }

    public static GccCompiler fromGenerator(String name, Log log) {
        if (!name.equals("Unix Makefiles")) {
            return null;
        }
        return new GccCompiler(log);
    }

    @Override
    public boolean compile(File projectPath, String platform, String buildType) throws IOException, InterruptedException {
        ArrayList commandLine = Lists.newArrayList((Object[])new String[]{"make"});
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine).directory(projectPath.getParentFile());
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("buildType: " + buildType));
            log.debug((CharSequence)("platform: " + platform));
            log.debug((CharSequence)("projectPath: " + projectPath));
            log.debug((CharSequence)("command-line: " + processBuilder.command()));
        }
        return Mojos.waitFor(processBuilder) == 0;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

