/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.googlecode.cmakemavenproject.Mojos;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class GenerateMojo
extends AbstractMojo {
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String classifier;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    private File sourcePath;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    private File targetPath;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String generator;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private Map<String, String> environmentVariables;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private BuildPluginManager pluginManager;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"})
    private MavenProject project;
    @SuppressWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private MavenSession session;
    private final boolean isPosix = !System.getProperty("os.name").toLowerCase().startsWith("windows");

    public void execute() throws MojoExecutionException {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        String version = pluginDescriptor.getVersion();
        try {
            int returnCode;
            Log log;
            if (!this.targetPath.exists() && !this.targetPath.mkdirs()) {
                throw new MojoExecutionException("Cannot create " + this.targetPath.getAbsolutePath());
            }
            String groupId = "com.googlecode.cmake-maven-project";
            String artifactId = "cmake-binaries";
            Plugin dependencyPlugin = MojoExecutor.plugin((String)"org.apache.maven.plugins", (String)"maven-dependency-plugin", (String)"2.4");
            if (this.classifier == null) {
                String os = System.getProperty("os.name");
                if (os.toLowerCase().startsWith("windows")) {
                    this.classifier = "windows";
                } else if (os.toLowerCase().startsWith("linux")) {
                    this.classifier = "linux";
                } else if (os.toLowerCase().startsWith("mac")) {
                    this.classifier = "mac";
                } else {
                    throw new MojoExecutionException("Unsupported os.name: " + os);
                }
            }
            Path cmakeDir = Paths.get(this.project.getBuild().getDirectory(), "dependency/cmake").toAbsolutePath();
            MojoExecutor.Element groupIdElement = new MojoExecutor.Element("groupId", "com.googlecode.cmake-maven-project", new MojoExecutor.Element[0]);
            MojoExecutor.Element artifactIdElement = new MojoExecutor.Element("artifactId", "cmake-binaries", new MojoExecutor.Element[0]);
            MojoExecutor.Element versionElement = new MojoExecutor.Element("version", version, new MojoExecutor.Element[0]);
            MojoExecutor.Element classifierElement = new MojoExecutor.Element("classifier", this.classifier, new MojoExecutor.Element[0]);
            MojoExecutor.Element outputDirectoryElement = new MojoExecutor.Element("outputDirectory", cmakeDir.toString(), new MojoExecutor.Element[0]);
            MojoExecutor.Element artifactItemElement = new MojoExecutor.Element("artifactItem", new MojoExecutor.Element[]{groupIdElement, artifactIdElement, versionElement, classifierElement, outputDirectoryElement});
            MojoExecutor.Element artifactItemsItem = new MojoExecutor.Element("artifactItems", new MojoExecutor.Element[]{artifactItemElement});
            Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{artifactItemsItem});
            MojoExecutor.ExecutionEnvironment environment = MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager);
            MojoExecutor.executeMojo((Plugin)dependencyPlugin, (String)"copy", (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)environment);
            Path binariesArchive = null;
            for (Path path : Files.newDirectoryStream(cmakeDir)) {
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                binariesArchive = path;
                break;
            }
            if (binariesArchive == null) {
                throw new IOException("Could not find cmake-binaries archive at: " + cmakeDir);
            }
            this.extract(binariesArchive, cmakeDir);
            ProcessBuilder processBuilder = new ProcessBuilder(cmakeDir.resolve("bin/cmake").toString(), this.sourcePath.getAbsolutePath(), "-G", this.generator).directory(this.targetPath);
            Map<String, String> env = processBuilder.environment();
            if (this.environmentVariables != null) {
                env.putAll(this.environmentVariables);
            }
            if ((log = this.getLog()).isDebugEnabled()) {
                log.debug((CharSequence)("sourcePath: " + this.sourcePath.getPath()));
                log.debug((CharSequence)("targetPath: " + this.targetPath.getPath()));
                log.debug((CharSequence)("command-line: " + processBuilder.command()));
                log.debug((CharSequence)("environment: " + processBuilder.environment()));
            }
            if ((returnCode = Mojos.waitFor(processBuilder)) != 0) {
                throw new MojoExecutionException("Return code: " + returnCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("", e);
        }
    }

    private void extract(Path source, Path target) throws IOException {
        Files.createDirectories(target, new FileAttribute[0]);
        String filename = source.getFileName().toString();
        String extension = this.getFileExtension(filename);
        String nameWithoutExtension = filename.substring(0, filename.length() - extension.length());
        String nextExtension = this.getFileExtension(nameWithoutExtension);
        switch (extension) {
            case ".jar": 
            case ".zip": {
                if (!nextExtension.isEmpty()) {
                    throw new UnsupportedOperationException("Unsupported file type: " + source);
                }
                this.extractZip(source, target);
                break;
            }
            case ".gz": {
                if (!nextExtension.isEmpty()) {
                    Path outputDir = Files.createTempDirectory("cmake", new FileAttribute[0]);
                    Path result = this.extractGzip(source, outputDir);
                    this.extract(result, target);
                    Files.deleteIfExists(result);
                    Files.deleteIfExists(outputDir);
                    break;
                }
                this.extractGzip(source, target);
                break;
            }
            case ".tar": {
                if (!nextExtension.isEmpty()) {
                    throw new UnsupportedOperationException("Unsupported file type: " + source);
                }
                this.extractTar(source, target);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported file type: " + source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractZip(Path source, Path target) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        try (ZipFile zipFile = new ZipFile(source.toFile());){
            Enumeration entries = zipFile.getEntriesInPhysicalOrder();
            block21: while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                ArrayList<FileAttribute<Set<PosixFilePermission>>> attributes = new ArrayList<FileAttribute<Set<PosixFilePermission>>>();
                if (this.isPosix) {
                    attributes.add(PosixFilePermissions.asFileAttribute(this.getPosixPermissions(entry.getUnixMode())));
                }
                if (entry.isDirectory()) {
                    Path directory = target.resolve(entry.getName());
                    Files.createDirectories(directory, new FileAttribute[0]);
                    if (!this.isPosix) continue;
                    Files.setPosixFilePermissions(directory, (Set)((FileAttribute)attributes.get(0)).value());
                    continue;
                }
                ReadableByteChannel reader = Channels.newChannel(zipFile.getInputStream(entry));
                Throwable throwable = null;
                try {
                    Path targetFile = target.resolve(entry.getName());
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    SeekableByteChannel out = Files.newByteChannel(targetFile, (Set<? extends OpenOption>)ImmutableSet.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.TRUNCATE_EXISTING, (Object)StandardOpenOption.WRITE), attributes.toArray(new FileAttribute[0]));
                    Throwable throwable2 = null;
                    try {
                        int count;
                        for (long bytesLeft = entry.getSize(); bytesLeft > 0L; bytesLeft -= (long)count) {
                            if (bytesLeft < (long)buffer.limit()) {
                                buffer.limit((int)bytesLeft);
                            }
                            if ((count = reader.read(buffer)) == -1) continue block21;
                            buffer.flip();
                            do {
                                out.write(buffer);
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractTar(Path source, Path target) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        try (TarArchiveInputStream in = new TarArchiveInputStream(Files.newInputStream(source, new OpenOption[0]));){
            while (true) {
                SeekableByteChannel out;
                block28: {
                    TarArchiveEntry entry;
                    if ((entry = in.getNextTarEntry()) == null) {
                        return;
                    }
                    ArrayList<FileAttribute<Set<PosixFilePermission>>> attributes = new ArrayList<FileAttribute<Set<PosixFilePermission>>>();
                    if (this.isPosix) {
                        attributes.add(PosixFilePermissions.asFileAttribute(this.getPosixPermissions(entry.getMode())));
                    }
                    if (entry.isDirectory()) {
                        Path directory = target.resolve(entry.getName());
                        Files.createDirectories(directory, new FileAttribute[0]);
                        if (!this.isPosix) continue;
                        Files.setPosixFilePermissions(directory, (Set)((FileAttribute)attributes.get(0)).value());
                        continue;
                    }
                    ReadableByteChannel reader = Channels.newChannel((InputStream)in);
                    Path targetFile = target.resolve(entry.getName());
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    out = Files.newByteChannel(targetFile, (Set<? extends OpenOption>)ImmutableSet.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.TRUNCATE_EXISTING, (Object)StandardOpenOption.WRITE), attributes.toArray(new FileAttribute[0]));
                    Throwable throwable = null;
                    try {
                        int count;
                        for (long bytesLeft = entry.getSize(); bytesLeft > 0L; bytesLeft -= (long)count) {
                            if (bytesLeft < (long)buffer.limit()) {
                                buffer.limit((int)bytesLeft);
                            }
                            if ((count = reader.read(buffer)) == -1) break;
                            buffer.flip();
                            do {
                                out.write(buffer);
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        if (out == null) continue;
                        if (throwable == null) break block28;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    out.close();
                                    throw throwable3;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                            }
                            out.close();
                            throw throwable3;
                        }
                    }
                    try {
                        out.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private Set<PosixFilePermission> getPosixPermissions(int mode) {
        StringBuilder result = new StringBuilder(9);
        for (int i = 3; i >= 1; --i) {
            int digit = (int)((double)(mode = (int)((double)mode % Math.pow(8.0, i))) / Math.pow(8.0, i - 1));
            if ((digit & 4) != 0) {
                result.append("r");
            } else {
                result.append("-");
            }
            if ((digit & 2) != 0) {
                result.append("w");
            } else {
                result.append("-");
            }
            if ((digit & 1) != 0) {
                result.append("x");
                continue;
            }
            result.append("-");
        }
        return PosixFilePermissions.fromString(result.toString());
    }

    private Path extractGzip(Path source, Path target) throws IOException {
        String filename = source.getFileName().toString();
        String extension = this.getFileExtension(filename);
        String nameWithoutExtension = filename.substring(0, filename.length() - extension.length());
        Path outPath = target.resolve(nameWithoutExtension);
        try (GzipCompressorInputStream in = new GzipCompressorInputStream(Files.newInputStream(source, new OpenOption[0]));
             OutputStream out = Files.newOutputStream(outPath, new OpenOption[0]);){
            int count;
            byte[] buffer = new byte[10240];
            while ((count = in.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
        }
        return outPath;
    }

    private String getFileExtension(String filename) {
        Preconditions.checkNotNull((Object)filename, (Object)"filename may not be null");
        Pattern pattern = Pattern.compile("[^\\.]+(\\.[\\p{Alnum}]+)$");
        Matcher matcher = pattern.matcher(filename);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }
}

